/* ---
 * f77 bit functions.
 * are not part of f2c but heavily used by HEP code. CERNLIB includes them
 * however there are HEP programs linked without CERNLIB - so we have to
 * provide them again.
 * ----------------------------------------------------------------------
 * (C) Wolfgang Wander 1996
 */

unsigned
ishftc_( unsigned *pattern, int *value, int *shiftp)
{
  int ival, jval;
  unsigned toshift, tokeep, mask;
  if( *value && *shiftp >= 1 && *shiftp <= 32 ) {
    mask = 0xffffffff << ( *shiftp );
    if( *value > 0 ) {
      ival = *value % *shiftp;
      jval = *shiftp - ival;
      toshift = (*pattern << ival) | ((*pattern & ~mask) >> jval);
      return (*pattern & mask) | (toshift & ~mask);
    } else if( *value < 0 ) {
      ival = (- *value) % *shiftp;
      jval = *shiftp - ival;
      toshift = (*pattern >> ival) | ((*pattern & ~mask) << jval);
      return (*pattern & mask) | (toshift & ~mask);
    }
  }
  return *pattern;
}

#ifdef TEST
main( )
{
  int v,k;
  unsigned p;
  
  while( scanf("%x %d %d",&p,&v,&k) == 3 ) {
    printf("%x\n", ishftc_(&p, &v, &k));
  }
}
#endif
