-- Copyright 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "GTK_COMBO - combo widget"
	author: "Daniel Elphick"
	cvs: "$Id: gtk_combo.e,v 1.2 1999/08/30 18:28:38 olly Exp $"

class GTK_COMBO

-- A combo box consists of a text entry box and a pull down menu. This enables
-- the user to either select an item from the menu or type it in manually.
inherit

	GTK_WIDGET

	GTK_COMBO_EXTERNALS
		undefine
			is_equal, copy
		end

	EGTK_NON_PORTABLE
		undefine
			is_equal, copy
		end

creation

	make

feature

	set_value_in_list(val: BOOLEAN; ok_if_empty: BOOLEAN) is
		local
			v, o: INTEGER
		do
			if val then v := 1 end
			if ok_if_empty then o := 1 end
			gtk_combo_set_value_in_list(widget, v, o)
		end

	set_use_arrows(val: BOOLEAN) is
		local
			v: INTEGER
		do
			if val then v := 1 end
			gtk_combo_set_use_arrows(widget, v)
		end
	
	set_use_arrows_always(val: BOOLEAN) is
		local
			v: INTEGER
		do
			if val then v := 1 end
			gtk_combo_set_use_arrows_always(widget, v)
		end

	set_case_sensitive(val: BOOLEAN) is
		local
			v: INTEGER
		do
			if val then v := 1 end
			gtk_combo_set_case_sensitive(widget, v)
		end

	set_item_string(item: GTK_ITEM; item_value: STRING) is
		do
			npc.np_gtk_combo_set_item_string(widget, item, item_value)
		end

	set_popdown_strings(strings: ARRAY[STRING]) is
		require
			strings /= Void
		do
			npc.np_gtk_combo_set_popdown_strings(widget, strings);
		end
			
	disable_activate is
		do
			gtk_combo_disable_activate(widget)
		end

	-- access this to read/set the entry
	entry: GTK_ENTRY

	list: GTK_LIST

feature {NONE}

	make is
			-- Create a new combo widget
		do
			widget := gtk_combo_new
			register_widget
			!!entry.make_from_pointer(c_gtk_combo_entry(widget))
			!!list.make_from_pointer(c_gtk_combo_list(widget))
		end

end -- GTK_COMBO
