indexing
	description: "GTK style class"
	status: "See notice at end of class"
	author: "Sam O'Connor"
	date: "$Date: 1999/11/04 08:47:19 $"
	revision: "$Revision: 1.2 $"

class

	GTK_CLASS

creation

	make

feature -- Initialization

	make (new_name: STRING) is
		do
			create scorer.make
			scorer.set_expression ("s/\([a-z]\)\([A-Z]\)/\1_\2/g")
			name := new_name
			scored_name := scorer.run (name)
			scored_name.to_lower
			create prototypes.make
			create signals.make
			create events.make
		end

feature -- Access

	name: STRING
			-- GtkClassName

	scored_name: STRING
			-- gtk_class_name

	parent_name: STRING
			-- GtkParentClassName

	scored_parent_name: STRING
			-- GtkParentClassName converted to gtk_parent_class_name

	set_parent_name (n: STRING) is
		do
			parent_name := clone (n)
			scored_parent_name := scorer.run (parent_name)
			scored_parent_name.to_upper
		end
	
	h_file_name: STRING
		-- Name of header file from which Current class comes

	set_h_file_name (new_h_file_name: STRING) is
		do
			h_file_name := new_h_file_name
		end

	prototypes: C_PROTOTYPES

	signals: LINKED_LIST [STRING]

	events: LINKED_LIST [STRING]

	gtk_universe: GTK_UNIVERSE

	set_gtk_universe (gu: GTK_UNIVERSE) is
		do
			gtk_universe := gu
		end

feature -- Output

        dump (dir: DIRECTORY; status: STRING) is
                        -- Dump eiffel text to a file in `dir'
                local
                        f: RAW_FILE
                        n: STRING
                do
                                n := clone (scored_name)
                                n.prepend ("c_")
                                n.append (".e")
                                n.prepend_character (operating_environment.directory_separator)
                                n.prepend (dir.name)
                                create f.make (n)
                                f.open_write
                                f.put_string (eiffel_text)
                                f.put_string (status)
                                f.close
                end

feature -- Conversion

	eiffel_text: STRING is
			-- Eiffel text of gtk class wrapper
		local
			r: FMT_STRING
			eif_name: STRING
		do
			eif_name := clone (scored_name)
			eif_name.to_upper
			eif_name.prepend ("C_")
			create r.make
			Result := r
			r.append ("indexing%N")
			r.append ("%Tdescription: %"External C calls to the GTK library.%"%N")
			r.append ("%Tgtk_klass: %"^%"%N")
			r.inject (name)
			r.append ("%Tgtk_file: %"^%"%N")
			r.inject (h_file_name)
			r.append ("%Tstatus: %"See notice at end of class%"%N")
			r.append ("%Tsignals: %"")
			from signals.start until signals.after
			loop
				r.append (signals.item)
				r.append (" ")
				signals.forth
			end
			r.append ("%"%N%Tevents: %"")
			from events.start until events.after
			loop
				r.append (events.item)
				r.append (" ")
				events.forth
			end
			r.append ("%"%N")
			r.append ("%Nclass%N%T^%N%N^end -- class ^%N")
			r.inject (eif_name)
			r.inject (prototypes.eiffel_text (gtk_universe.include_directive))
			r.inject (eif_name)
		end

	gel_class: GEL_CLASS is
			-- class providing nice interface to c_ wrapper class
		local
			desc: STRING
			externs: STRING
			f: GEL_FEATURE
			p: C_PROTOTYPE
			a: GEL_ARGUMENT
			ca: C_ARGUMENT
			s, call: FMT_STRING
			td: C_TYPEDEF
			gtkc: GTK_CLASS
			ptr2obj: BOOLEAN
			close_paren: BOOLEAN
		do
			create Result.make (scored_name)
			if parent_name /= Void then
				Result.set_parent_name (scored_parent_name)
			end
			externs := "C_"
			externs.append (scored_name)
			Result.set_externals_name (externs)

			desc := "Wrapper for "
			desc.append (name)
			Result.set_description (desc)

			Result.set_signals (signals)
			Result.set_events (events)

			from prototypes.start
			until prototypes.after
			loop
				ptr2obj := False
				close_paren := False
				p :=  prototypes.item
				create f.make (Result, p.name)
				create call.make
				gtkc := gtk_universe.classes.class_by_name (p.type)
				if f.is_creation then
					call.append ("make_from_c_pointer (")
					close_paren := True
				elseif gtkc /= Void and p.indir = 1 then
					f.set_type (gtkc.scored_name)
					f.locals.extend ("p: POINTER")
					call.append ("p := ")
					ptr2obj := True
				elseif p.indir + p.typedef.indir /= 0 then
					f.set_type ("POINTER")
					call.append ("Result := ")
				elseif p.type /= Void and not p.typedef.base.is_equal ("void") then
					f.set_type (p.typedef.base)
					call.append ("Result := ")
				end
				call.append ("c_^.^")
				call.inject (scored_name)
				call.inject (p.name)
				if p.arguments.count > 0 then
					call.append (" (")
					from
						p.arguments.start
						if p.arguments.item.indir = 1 and p.arguments.item.type.is_equal (name) then
							call.append ("c_object")
							p.arguments.forth
						end
					until p.arguments.after
					loop
						if not p.arguments.isfirst then
							call.append (", ")
						end
						ca := p.arguments.item
						create a.make (ca.name, ca.typedef.base)
						f.args.extend (a)
						gtkc := gtk_universe.classes.class_by_name (ca.type)
						if gtkc /= Void and ca.indir = 1 then
							a.set_type (gtkc.scored_name)
							call.append (ca.name)
							call.append (".c_object")
						elseif (ca.indir + ca.typedef.indir = 1) and ca.typedef.base.is_equal ("char") then
							a.set_type ("STRING")
							call.append ("e2c (^)")
							call.inject (ca.name)
						elseif (ca.indir + ca.typedef.indir = 2) and ca.typedef.base.is_equal ("char") then
							a.set_type ("LIST [STRING]")
							call.append ("e2c (^)")
							call.inject (ca.name)
						elseif (ca.indir + ca.typedef.indir /= 0) then
							a.set_type ("POINTER")
							call.append (ca.name)
						elseif ca.typedef.base.is_equal ("char") then
							a.set_type ("INTEGER")
							call.append (ca.name)
						else
							call.append (ca.name)
						end
						p.arguments.forth
					end
					call.append (")")
				end
				f.main_do.extend (call)
				if close_paren then
					call.append (")")
				end
				if ptr2obj then
					f.main_do.extend ("Result ?= objects_by_c_pointer.item (p)")
					f.main_do.extend ("if Result = Void then")
					f.main_do.extend ("%Tcreate Result.make_from_c_pointer (p)")
					f.main_do.extend ("end")
				end
				prototypes.forth
			end

		end


feature {NONE} -- Implementation

	scorer: STRING_EDITOR

invariant

	name_valid: name /= Void
	name_not_empty: name.count > 0 and scored_name.count > 0

end -- class GTK_CLASS


--!-----------------------------------------------------------------------------
--! The GOTE converter. It converts GTK+ Objects To Eiffel.
--! Copyright (C) 1999 Sam O'Connor
--!
--! This program is free software; you can redistribute it and/or modify
--! it under the terms of the GNU General Public License as published by
--! the Free Software Foundation; either version 2 of the License, or
--! (at your option) any later version.
--!
--! This program is distributed in the hope that it will be useful,
--! but WITHOUT ANY WARRANTY; without even the implied warranty of
--! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--! GNU General Public License for more details.
--!
--! You should have received a copy of the GNU General Public License
--! along with this program; if not, write to the Free Software
--! Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
--!
--! See file "licence" for more information.
--!-----------------------------------------------------------------------------
