indexing
	description: "Preprocess a C header file"
	status: "see notice at end of class"
	author: "Sam O'Connor"
	date: "$Date: 1999/10/31 10:36:41 $"
	revision: "$Revision: 1.1.1.1 $"

class
	C_PREPROCESSOR

inherit
	EXECUTION_ENVIRONMENT	

	TMP_FILE_NAMER

feature -- Transformation

	preprocess (h_file_name, c_flags: STRING): STRING is
			-- preprocess a .h file (gcc -E -P)
			-- return name of output file
		require
			valid_h_file_name: h_file_name /= Void
			valid_c_flags: c_flags /= Void
		local
			cmd: STRING
		do
			Result := tmp_file_name
			cmd := "gcc -E "
			cmd.append (c_flags)
			cmd.append (" ")
			cmd.append (h_file_name)
			cmd.append (" > ")
			cmd.append (Result)
			system (cmd)			
		end

end -- class C_PREPROCESSOR


--!-----------------------------------------------------------------------------
--! The GOTE converter. It converts GTK+ Objects To Eiffel.
--! Copyright (C) 1999 Sam O'Connor
--!
--! This program is free software; you can redistribute it and/or modify
--! it under the terms of the GNU General Public License as published by
--! the Free Software Foundation; either version 2 of the License, or
--! (at your option) any later version.
--!
--! This program is distributed in the hope that it will be useful,
--! but WITHOUT ANY WARRANTY; without even the implied warranty of
--! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--! GNU General Public License for more details.
--!
--! You should have received a copy of the GNU General Public License
--! along with this program; if not, write to the Free Software
--! Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
--!
--! See file "licence" for more information.
--!-----------------------------------------------------------------------------
