indexing
	description: "Argument to a C function. Name, indirection and type."
	status: "See notice at end of class"
	author: "Sam O'Connor"
	date: "$Date: 1999/11/19 21:21:30 $"
	revision: "$Revision: 1.2 $"

class
	C_ARGUMENT

creation
	make,
	make_with_type,
	make_with_type_and_indir

feature -- Initialization

	make (new_name: STRING) is
		require
			name_not_void: new_name /= Void
		do
			name := clone (new_name)
		end

	make_with_type (new_name, new_type: STRING) is
		require
			name_not_void: new_name /= Void
			type_not_void: new_type /= Void
		do
			name := clone (new_name)
			type := clone (new_type)
		end

	make_with_type_and_indir (new_name, new_type: STRING; new_indir: INTEGER) is
		require
			name_not_void: new_name /= Void
			type_not_void: new_type /= Void
		do
			name := clone (new_name)
			type := clone (new_type)
			indir := new_indir
		end

feature -- Access

	name: STRING

	type: STRING

	indir: INTEGER

	typedef: C_TYPEDEF
	
feature -- Status setting

	set_type (new_type: STRING) is
		do
			type := clone (new_type)
		end

	set_indir (new_indir: INTEGER) is
		do
			indir := new_indir
		end

	set_typedef (new_typedef: C_TYPEDEF) is
		do
			typedef := new_typedef
		end

invariant

	valid_name: name /= Void

end -- class C_ARGUMENT


--!-----------------------------------------------------------------------------
--! The GOTE converter. It converts GTK+ Objects To Eiffel.
--! Copyright (C) 1999 Sam O'Connor
--!
--! This program is free software; you can redistribute it and/or modify
--! it under the terms of the GNU General Public License as published by
--! the Free Software Foundation; either version 2 of the License, or
--! (at your option) any later version.
--!
--! This program is distributed in the hope that it will be useful,
--! but WITHOUT ANY WARRANTY; without even the implied warranty of
--! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--! GNU General Public License for more details.
--!
--! You should have received a copy of the GNU General Public License
--! along with this program; if not, write to the Free Software
--! Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
--!
--! See file "licence" for more information.
--!-----------------------------------------------------------------------------
