-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for GtkText objects"
	author: "Daniel Elphick <de397@ecs.soton.ac.uk>"

class GTK_TEXT_WRITER

inherit

	GTK_ATTRIBUTE_WRITER
		rename
			make as make_attribute
		redefine
			append_parent_creation
		end

	CHILD

creation

	make

feature

	type: STRING is "GTK_TEXT"

	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		do
			make_attribute(attr_name, tree, src)
			editable := widget_tree.get_boolean_string_from_field("editable")
			text := widget_tree.get_string_from_field("text")
		end
			
	text: STRING
	editable: STRING
	
	append_parent_creation(code: ARRAY[STRING]) is
		do
			code.add_last("!!" + name + ".make")
			code.add_last(name + ".set_text(%"" + text +"%")")
			code.add_last(name + ".set_editable(" + editable + ")")
			add_widget_code(code)
		end

end
