-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for GtkProgressBar objects"
	author: "Daniel Elphick <de397@ecs.soton.ac.uk>"

class GTK_PROGRESS_BAR_WRITER

inherit

	GTK_ATTRIBUTE_WRITER
		rename
			make as make_attribute
		redefine
			append_parent_creation, parent_inherit
		end
	
	CHILD

creation

	make

feature

		
	type: STRING is "GTK_PROGRESS_BAR"

	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		do
			make_attribute(attr_name, tree, src)
			value := widget_tree.get_real_string_from_field("value")
			lower := widget_tree.get_real_string_from_field("lower")
			upper := widget_tree.get_real_string_from_field("upper")
			bar_style := widget_tree.get_string_from_field("bar_style")
			orientation := widget_tree.get_string_from_field("orientation")
			activity_mode := widget_tree.get_boolean_string_from_field("activity_mode")
			show_text := widget_tree.get_boolean_string_from_field("show_text")
			format := widget_tree.get_string_from_field("format")
			text_xalign := widget_tree.get_real_string_from_field("text_xalign")
			text_yalign := widget_tree.get_real_string_from_field("text_yalign")
		end
			
	value: STRING
	lower: STRING
	upper: STRING
	bar_style: STRING
	orientation: STRING
	activity_mode: STRING
	show_text: STRING
	format: STRING
	text_xalign: STRING
	text_yalign: STRING
	
	append_parent_creation(code: ARRAY[STRING]) is
		do
			code.add_last("!!" + name + ".make")
			code.add_last(name + ".set_show_text("+ show_text +")")
			code.add_last(name + ".set_text_alignment("+
				text_xalign + ", " + text_yalign + ")")
			code.add_last(name + ".set_format_string(%""+ format +"%")")
			code.add_last(name + ".configure("+ value + ", " + 
				lower + ", " + upper +")")
			code.add_last(name + ".set_activity_mode(" + activity_mode + ")")
			code.add_last(name + ".set_orientation("+ orientation + ")")
			code.add_last(name + ".set_bar_style("+ bar_style + ")")
			add_widget_code(code)
		end

	parent_inherit: INHERIT_LIST is
		local
			temp: KLASS
		do
			!!Result.make
			!!temp.make_with_name("GTK_PROGRESS_BAR_EXTERNALS")
			temp.add_undefine_clause("is_equal, copy")
			Result.add(temp)
		end

end
