-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for GtkFileSelection objects"
	author: "Daniel Elphick <de397@ecs.soton.ac.uk>"

class GTK_FILE_SELECTION_WRITER

inherit

	GTK_ATTRIBUTE_WRITER
		rename
			make as make_attribute
		redefine
			append_parent_creation
		end

	CHILD

creation

	make

feature

	type: STRING is "GTK_FILE_SELECTION"
	ok: TAG_TREE
	cancel: TAG_TREE
	
	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		local
			tree_array: ARRAY[TAG_TREE]
			i: INTEGER
		do
			make_attribute(attr_name, tree, src)
			title := widget_tree.get_string_from_field("title")
			window_type := widget_tree.get_string_from_field("type")
			position := widget_tree.get_string_from_field("position")
			modal := widget_tree.get_boolean_string_from_field("modal")
			allow_shrink := widget_tree.get_boolean_string_from_field("allow_shrink")
			allow_grow := widget_tree.get_boolean_string_from_field("allow_grow")
			auto_shrink := widget_tree.get_boolean_string_from_field("auto_shrink")
			show_file_op_buttons := widget_tree.get_boolean_from_field("show_file_op_buttons", True)
			tree_array := widget_tree.find_children("widget")
			if tree_array.count /= 2 then
				print("FileSelection window should have 2 widgets%N")
				die_with_code(exit_failure_code)
			end
			-- assume first one is ok button and second is cancel
			if not (tree_array @ 0).get_string_from_field("child_name").is_equal("FileSel:ok_button") then
				print("First widget should be the ok button%N")
				die_with_code(exit_failure_code)
			end
			if not (tree_array @ 1).get_string_from_field("child_name").is_equal("FileSel:cancel_button") then
				print("Second widget should be the cancel button%N")
				die_with_code(exit_failure_code)
			end
			ok := tree_array @ 0
			cancel := tree_array @ 1
			check 
				ok /= Void and then cancel /= Void
			end
			
		end
			
	title: STRING
	window_type: STRING
	position: STRING
	modal: STRING
	allow_shrink: STRING
	allow_grow: STRING
	auto_shrink: STRING
	show_file_op_buttons: BOOLEAN

	-- NB glade lets you create names for the ok and cancel box.
	-- However I think these are irrelevant in eiffel. If you really want them
	-- email me and i'll put them in
	append_parent_creation(code: ARRAY[STRING]) is
		local
			temp: STRING
		do
			code.add_last("!!" + name + ".make_with_title(%""+title+"%")")
			if show_file_op_buttons then
				code.add_last(name + ".show_file_ops_buttons")
			else
				code.add_last(name + ".hide_file_ops_buttons")
			end
			code.add_last(name + ".set_policy(" + allow_shrink + ", " +
				allow_grow + ", " + auto_shrink + ")")
			temp := ok.get_string_from_field("label")
			if not temp.empty and then not temp.is_equal("OK") then
				code.add_last(name + ".ok.set_label(%""+temp+"%")")
			end
			temp := cancel.get_string_from_field("label")
			if not temp.empty and then not temp.is_equal("Cancel") then
				code.add_last(name + ".cancel.set_label(%""+temp+"%")")
			end
			add_widget_code(code)
		end

end
