-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Template for all attribute writers"
	author: "Daniel Elphick <de397@ecs.soton.ac.uk>"

deferred class GTK_ATTRIBUTE_WRITER

inherit

	WRITER

	CAN_BE_CREATED

	SIGNAL_COMMON

feature

	type: STRING is
		deferred
		end

	name: STRING
	border_width: STRING
	x: STRING
	y: STRING
	width: STRING
	height: STRING
	visible: BOOLEAN
	sensitive: BOOLEAN
	tooltip: STRING
	can_default: BOOLEAN
	has_default: BOOLEAN
	can_focus: BOOLEAN
	has_focus: BOOLEAN
	events: STRING
	extension_events: STRING

	parent_inherit: INHERIT_LIST is
		do
			!!Result.make
		end

	append_parent_declaration(code: ARRAY[STRING]) is
		do
			code.add_last(name+": "+type)
			append_signal_declarations(code)
		end
	
	append_parent_creation(code: ARRAY[STRING]) is
		do
			code.add_last("!!"+name+".make")
			add_widget_code(code)
		end

	append_top_level_show(code: ARRAY[STRING]) is
		do
		end

	append_top_level_definition(code: ARRAY[STRING]) is
		do
		end

feature {NONE}

	add_widget_code(strings: ARRAY[STRING]) is
		local
			write_instruction: BOOLEAN
			flags: STRING
			i: INTEGER
		do
			-- only containers can have the border_width flag but checking
			-- should never reveal a border_width flag for a non-container
			-- unless glade is faulty
			if border_width /= Void then
				strings.add_last(name + ".set_border_width("+border_width+")")
			end
			if not tooltip.empty then
				strings.add_last(name + ".set_tool_tip(%""+tooltip+"%")")
			end
			-- -2 means don't change this value
			if x /= Void then
				write_instruction := True
			else
				x := "-2"
			end
			if y /= Void then
				write_instruction := True
			else
				y := "-2"
			end
			if write_instruction then
				strings.add_last(name + ".set_position("+x+", "+y+")")
			end
			write_instruction := False
			if width /= Void then
				write_instruction := True
			else
				width := "-2"
			end
			if height /= Void then
				write_instruction := True
			else
				height := "-2"
			end
			if write_instruction then
				strings.add_last(name + ".set_size("+width+", "+height+")")
			end
			-- HERE I ASSUME IT DEFAULTS TO SENSITIVE
			if not sensitive then
				strings.add_last(name + ".set_sensitive(False)")
			end
			if can_default then
				strings.add_last(name + ".set_flags(Gtk_can_default)")
			end
			if can_focus then
				strings.add_last(name + ".set_flags(Gtk_can_focus)")
			end
			if has_default then
				strings.add_last(name + ".grab_default")
			end
			if has_focus then
				-- tough luck feature doesn't exist in GTK_WIDGET
				print("grab_focus hasn't been implemented in eGTK%N")
			end
			if not events.empty then
				-- if there are a lot of events this won't format it very nicely
				events.replace_all('|', '+') -- SmallEiffel doesn't have OR for
								   		     -- INTEGERs
				strings.add_last(name + ".set_events("+ events + ")")
			end
			if visible then 
				strings.add_last(name + ".show")
			end
			append_signal_code(strings, name)
		end
	
	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		local
			signal_trees: ARRAY[TAG_TREE]
		do
			src_dir := src
			widget_tree := tree
			name := clone(attr_name)
			-- get general attribute flags
			-- if the tag is not present then generally no code will be
			-- generated for it
			border_width := tree.get_integer_string_from_field("border_width")
			x := tree.get_integer_string_from_field("x")
			y := tree.get_integer_string_from_field("y")
			width := tree.get_integer_string_from_field("width")
			height := tree.get_integer_string_from_field("height")
			visible := tree.get_boolean_from_field("visible", True)
			sensitive := tree.get_boolean_from_field("sensitive", True)
			tooltip := tree.get_string_from_field("tooltip")
			can_default := tree.get_boolean_from_field("can_default", False)
			has_default := tree.get_boolean_from_field("has_default", False)
			can_focus := tree.get_boolean_from_field("can_focus", False)
			has_focus := tree.get_boolean_from_field("has_focus", False)
			events := tree.get_string_from_field("events")
			extension_events := tree.get_string_from_field("extension_events")
			-- find signals
			make_signals(tree.find_children("signal"))
		end

end
