# Macro to add for using GNU gettext.
# Ulrich Drepper <drepper@cygnus.com>, 1995.
# Very much modified and simplified by Julian Gilbey <jdg@debian.org>
# for use with a script-only package
# Copyright 1999, Julian Gilbey
# This file/program may be distributed under the conditions of the
# GNU General Public License, version 2 or later.  NO WARRANTY is implied.

# The devscripts package contains only scripts (Perl and Bash).  They
# currently assume that the gettext library is present: Bash has its
# own implementation, and the Perl Locale::gettext library assumes that
# it is present in libc.  At present, I am not handling the case where
# this is not true; this package is essentially designed for Debian
# developers where it is.
#
# Therefore this is a much simplified version of the original aclocal.m4
# file.

AC_DEFUN(AM_SCRIPTS_WITH_NLS,
  [AC_MSG_CHECKING([whether NLS is requested])
    dnl Default is enabled NLS
    AC_ARG_ENABLE(nls,
      [  --disable-nls           do not use Native Language Support],
      USE_NLS=$enableval, USE_NLS=yes)
    AC_MSG_RESULT($USE_NLS)
    AC_SUBST(USE_NLS)

    CATOBJEXT=
    if test "$USE_NLS" = yes; then
      dnl I don't understand this bit, but I'll keep it anyone
      AM_PATH_PROG_WITH_TEST(MSGFMT, msgfmt,
        [test -z "`$ac_dir/$ac_word -h 2>&1 | grep 'dv '`"], no)dnl
      if test "$MSGFMT" != "no"; then
        AC_PATH_PROG(GMSGFMT, gmsgfmt, $MSGFMT)
        dnl Hmm.  What are we to do with this?  We are not looking at libraries.
        dnl The following replacement will have to do.
        dnl AC_TRY_LINK(, [extern int _nl_msg_cat_cntr;
        dnl   return _nl_msg_cat_cntr],
        if $GMSGFMT --version 2>/dev/null |
             grep "(GNU gettext)" >/dev/null 2>/dev/null; then
          CATOBJEXT=.gmo
          DATADIRNAME=share
        else
          CATOBJEXT=.mo
          DATADIRNAME=lib
        fi
        INSTOBJEXT=.mo
      else
        AC_PATH_PROG(GETTEXT, gettext, no)
        if test "$GETTEXT" = no; then
          AC_MSG_WARN(
[You need the msgfmt utility installed to be able to recreate the
message catalogues.  You need the gettext utility installed to be
able to use them.  Ignoring message catalogs.])
          $USE_NLS=no
        else
          AC_MSG_WARN(
[You need the msgfmt utility installed to be able to recreate the
message catalogues.  I will try to install them anyway as you have
a gettext binary available.])
          if $GETTEXT --version 2>/dev/null |
               grep "(GNU gettext)" >/dev/null 2>/dev/null; then
            CATOBJEXT=.gmo
            DATADIRNAME=share
          else
            CATOBJEXT=.mo
            DATADIRNAME=lib
          fi
        INSTOBJEXT=.mo
        fi
      fi
    fi

    dnl These rules are solely for the distribution goal.  While doing this
    dnl we only have to keep exactly one list of the available catalogs
    dnl in configure.in.
    for lang in $ALL_LINGUAS; do
      GMOFILES="$GMOFILES $lang.gmo"
      POFILES="$POFILES $lang.po"
    done

    dnl Make all variables we use known to autoconf.
    AC_SUBST(CATALOGS)
    AC_SUBST(CATOBJEXT)
    AC_SUBST(DATADIRNAME)
    AC_SUBST(GMOFILES)
    AC_SUBST(INSTOBJEXT)
    AC_SUBST(POFILES)
  ])

AC_DEFUN(AM_SCRIPTS_GNU_GETTEXT,
  [AC_REQUIRE([AC_PROG_MAKE_SET])dnl
    AM_WITH_NLS
 
    if test "x$CATOBJEXT" != "x"; then
      if test "x$ALL_LINGUAS" = "x"; then
 	LINGUAS=
      else
 	AC_MSG_CHECKING(for catalogs to be installed)
 	NEW_LINGUAS=
 	for lang in ${LINGUAS=$ALL_LINGUAS}; do
 	  case "$ALL_LINGUAS" in
 	   *$lang*) NEW_LINGUAS="$NEW_LINGUAS $lang" ;;
 	  esac
 	done
 	LINGUAS=$NEW_LINGUAS
 	AC_MSG_RESULT($LINGUAS)
      fi
 
      dnl Construct list of names of catalog files to be constructed.
      if test -n "$LINGUAS"; then
 	for lang in $LINGUAS; do CATALOGS="$CATALOGS $lang$CATOBJEXT"; done
      fi
    fi
 
    dnl If the AC_CONFIG_AUX_DIR macro for autoconf is used we possibly
    dnl find the mkinstalldirs script in another subdir but ($top_srcdir).
    dnl Try to locate is.
    MKINSTALLDIRS=
    if test -n "$ac_aux_dir"; then
      MKINSTALLDIRS="$ac_aux_dir/mkinstalldirs"
    fi
    if test -z "$MKINSTALLDIRS"; then
      MKINSTALLDIRS="\$(top_srcdir)/mkinstalldirs"
    fi
    AC_SUBST(MKINSTALLDIRS)
  ])
