(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                              Inclusion.v                                 *)
(****************************************************************************)
(*                              Bruno Barras                                *)
(****************************************************************************)

Require Relation_Definitions.

Section WfInclusion.
  Variable A:Set.
  Variable R1,R2:A->A->Prop.

  Lemma Acc_incl: (inclusion A R1 R2)->(z:A)(Acc A R2 z)->(Acc A R1 z).
Induction 2;Intros.
(Apply Acc_intro;Auto with sets).
Save.

  Hints Resolve Acc_incl.

  Theorem wf_incl: (inclusion A R1 R2)->(well_founded A R2)->(well_founded A R1).
(Unfold well_founded ;Auto with sets).
Save.


End WfInclusion.

(* $Id: Inclusion.v,v 1.7 1999/06/29 07:48:56 loiseleu Exp $ *)
