(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(* Certification of Imperative Programs                                     *)
(* Jean-Christophe Fillitre                                                *)
(****************************************************************************)
(*                               progAst.mli                                *)
(****************************************************************************)

(* Generated automatically by ocamlc -i *)

type termination = | RecArg of int | Wf of CoqAst.t * CoqAst.t
type variable = Names.identifier
type pattern =
  | PatVar of Names.identifier
  | PatConstruct of Names.identifier * ((Names.section_path * int) * int)
  | PatAlias of pattern * Names.identifier
  | PatPair of pattern * pattern
  | PatApp of pattern list
type epattern =
  | ExnConstant of Names.identifier
  | ExnBind of Names.identifier * Names.identifier
type ('a, 'b) block_st =
  | Label of string
  | Assert of 'b ProgTypes.assertion
  | Statement of 'a
type ('a, 'b) block = ('a, 'b) block_st list
type ('a, 'b) t =
  { desc: ('a, 'b) t_desc;
    pre: 'b ProgTypes.precondition list;
    post: 'b ProgTypes.postcondition option;
    loc: CoqAst.loc;
    info: 'a }
and ('a, 'b) t_desc =
  | Var of variable
  | Acc of variable
  | Aff of variable * ('a, 'b) t
  | TabAcc of bool * variable * ('a, 'b) t
  | TabAff of bool * variable * ('a, 'b) t * ('a, 'b) t
  | Seq of (('a, 'b) t, 'b) block
  | While of ('a, 'b) t * 'b ProgTypes.assertion option * ('b * 'b) *
               (('a, 'b) t, 'b) block
  | If of ('a, 'b) t * ('a, 'b) t * ('a, 'b) t
  | Lam of 'b ProgTypes.ml_type_v ProgTypes.binder list * ('a, 'b) t
  | App of ('a, 'b) t * ('a, 'b) arg list
  | SApp of ('a, 'b) t_desc list * ('a, 'b) t list
  | LetRef of variable * ('a, 'b) t * ('a, 'b) t
  | LetIn of variable * ('a, 'b) t * ('a, 'b) t
  | LetRec of variable * 'b ProgTypes.ml_type_v ProgTypes.binder list *
                'b ProgTypes.ml_type_v * ('b * 'b) * ('a, 'b) t
  | PPoint of string * ('a, 'b) t_desc
  | Expression of Term.constr
  | Debug of string * ('a, 'b) t
and ('a, 'b) arg =
  | Term of ('a, 'b) t
  | Refarg of variable
  | Type of 'b ProgTypes.ml_type_v
type program = (unit, CoqAst.t) t
type cc_type = Term.constr
type cc_bind_type = | CC_typed_binder of cc_type | CC_untyped_binder
type cc_binder = variable * cc_bind_type
type cc_term =
  | CC_var of variable
  | CC_letin of bool * cc_type * cc_binder list * (cc_term * Term.constr) *
                  cc_term
  | CC_lam of cc_binder list * cc_term
  | CC_app of cc_term * cc_term list
  | CC_tuple of bool * cc_type list * cc_term list
  | CC_case of cc_type * (cc_term * Term.constr) * cc_term list
  | CC_expr of Term.constr
  | CC_hole of cc_type
