(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(* Certification of Imperative Programs                                     *)
(* Jean-Christophe Fillitre                                                *)
(****************************************************************************)
(*                                monad.mli                                 *)
(****************************************************************************)

open Names
open Term

open ProgTypes
open ProgAst
open Prog_env

(* Main part of the translation of imperative programs into functional ones
 * (with mlise.ml) *)

(* Here we translate the specification into a CIC specification *)

val trad_ml_type_v : Renamings.t -> local_env -> type_v -> constr
val trad_ml_type_c : Renamings.t -> local_env -> type_c -> constr
val trad_imp_type  : Renamings.t -> local_env -> type_v -> constr
val trad_type_in_env : Renamings.t -> local_env -> identifier -> constr

val binding_of_alist : Renamings.t -> local_env
                    -> (identifier * identifier) list
		    -> cc_binder list
val make_abs : cc_binder list -> cc_term -> cc_term
val abs_pre : Renamings.t -> local_env -> cc_term * constr -> 
  constr precondition list -> cc_term

(* The following functions translate the main constructions *)

val make_tuple : (cc_term * cc_type) list -> predicate option
          -> Renamings.t -> local_env -> string
          -> cc_term

val result_tuple : Renamings.t -> string -> local_env
          -> (cc_term * constr) -> (Effects.t * predicate option)
          -> cc_term * constr

val let_in_pre : constr -> constr precondition -> cc_term -> cc_term

val make_let_in : Renamings.t -> local_env -> cc_term 
          -> constr precondition list
          -> ((identifier * identifier) list * predicate option) 
	  -> identifier * constr
	  -> cc_term * constr -> cc_term

val make_block : Renamings.t -> local_env
          -> (Renamings.t -> (identifier * constr) option -> cc_term * constr)
	  -> (cc_term * type_c, constr) block
	  -> cc_term

val make_app : local_env
          -> Renamings.t -> (cc_term * type_c) list
	  -> Renamings.t -> cc_term * type_c
	  -> ((type_v binder list) * type_c)
	    * ((identifier*identifier) list)
	    * type_c
	  -> type_c
          -> cc_term

val make_if : Renamings.t -> local_env 
         -> cc_term * type_c
	 -> Renamings.t
         -> cc_term * type_c
         -> cc_term * type_c
         -> type_c
         -> cc_term

val make_while : Renamings.t -> local_env
         -> (constr * constr * constr) (* typed variant *)
         -> cc_term * type_c
         -> (cc_term * type_c, constr) block
         -> constr assertion option * type_c
         -> cc_term

val make_letrec : Renamings.t -> local_env
         -> (identifier * (constr * constr * constr)) (* typed variant *)
	 -> identifier (* the name of the function *)
         -> (cc_binder list)
	 -> (cc_term * type_c)
	 -> type_c
         -> cc_term

(* Functions to translate array operations *)

val array_info :
  Renamings.t -> local_env -> identifier -> constr * constr * constr

val make_raw_access :
  Renamings.t -> local_env -> identifier * identifier -> constr -> constr

val make_raw_store :
  Renamings.t -> local_env -> identifier * identifier 
    -> constr -> constr -> constr

val make_pre_access :
  Renamings.t -> local_env -> identifier -> constr -> constr

(* $Id: monad.mli,v 1.49 1999/06/29 07:48:20 loiseleu Exp $ *)
