(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(* Certification of Imperative Programs                                     *)
(* Jean-Christophe Fillitre                                                *)
(****************************************************************************)
(*                               effects.mli                                *)
(****************************************************************************)

open Names

(* The abstract type of effects *)

type t

val bottom : t
val add_read  : identifier -> t -> t
val add_write : identifier -> t -> t

val get_reads : t -> identifier list
val get_writes : t -> identifier list
val get_repr : t -> (identifier list) * (identifier list)

val is_read  : t -> identifier -> bool    (* read-only *)
val is_write : t -> identifier -> bool    (* read-write *)

val compose : t -> t -> t

val union : t -> t -> t
val disj : t -> t -> t

val remove : t -> identifier -> t

val subst : (identifier * identifier) list -> t -> t


val pp : t -> Pp.std_ppcmds
val ppr : t -> unit

(* $Id: effects.mli,v 1.19 1999/06/29 07:48:19 loiseleu Exp $ *)
