open Vectops;;
open Classops;;
open Names;;
open CoqAst;;
open Ast;;
open Termast;;
open Term;;
open Std;;
open Constrtypes;;
open Reduction;;
open Generic;;
open Termenv;;
open Libobject;;
open Environ;;


(* This function converts the parameter binders of an inductive definition,
   in particular you have to be careful to handle each element in the
   context containing all previously defined variables.  This squeleton
   of this procedure is taken from the function print_env in pretty.ml *)
let convert_env =
    let convert_binder env (na, c) =
      match na with 
       | Name id ->
           ope("BINDER",
               [bdize_no_casts true (unitize_env env) c;nvar(string_of_id id)])
       | Anonymous -> anomaly "Anonymous variables in inductives" in
    let rec cvrec env = function
       [] -> []
     | b::rest -> (convert_binder env b)::(cvrec (add_rel b env) rest) in
    cvrec (gLOB nil_sign);;

(* let mib string = 
     let sp = Nametab.sp_of_id CCI (id_of_string string) in
     let lobj = Lib.map_leaf (objsp_of sp) in
     let (cmap, _) = outMutualInductive lobj in
     Listmap.map cmap CCI;; *)

let impl_args_to_string = function
    [] -> None
  | [i] -> Some(" position " ^ (string_of_int i) ^ " is implicit.")
  | l -> Some (" positions " ^
                (List.fold_right (fun i s -> (string_of_int i) ^ " " ^ s)
                     l
                     " are implicit."));;

let implicit_args_id_to_ast_list (id,l) ast_list = 
    (match impl_args_to_string (list_of_implicits l) with
           None -> ast_list
         | Some(s) -> (str("For " ^ (string_of_id id)))::
                       (str s)::
                       ast_list);;

let implicit_args_to_ast_list mipv =
    let implicit_args_descriptions = 
       (List.fold_right
         (fun mip ast_list ->
             (implicit_args_id_to_ast_list (mip.mINDTYPENAME,
                       mip.mINDIMPLICITS))
             (List.fold_right implicit_args_id_to_ast_list
                 (List.combine (Array.to_list mip.mINDCONSNAMES)
                    (Array.to_list mip.mINDCONSIMPLICITS))
                 ast_list))
         (Array.to_list mipv)
         []) in
    (match implicit_args_descriptions with
       [] -> []
      | _ -> [ope("COMMENT",
                  implicit_args_descriptions)]);;

(* This function converts a Mutual inductive definition.  It is obtained
   directly from print_mutual in pretty.ml.  However, all references to
   kinds have been removed and it treats only CCI stuff. *)

let mutual_to_ast_list mib =
  let evd = Evd.mt_evd() in
  let {mINDPACKETS=mipv; mINDNPARAMS=nparams} = mib in
  let (lpars,_)= decomp_n_prod evd nparams (body_of_type mipv.(0).mINDARITY) in
  let lparsname = List.map fst lpars in
  let lparsprint = assumptions_for_print lparsname in
  let convert_ass assumptions (id,c) =
      let ast_c = bdize_no_casts true assumptions c in
      ope("BINDER", [ast_c; nvar(string_of_id id)]) in

  let convert_constructor mip =
  let (lna,lC) = decomp_all_DLAMV_name mip.mINDLC in
  let ass_name = assumptions_for_print (lparsname@lna) in
  let lidC = 
      Array.to_list
       (map2_vect (fun id c -> (id, snd (decomp_n_prod evd nparams c)))
          mip.mINDCONSNAMES lC) in
      Node((0,0),"BINDERLIST",
        (List.map (convert_ass ass_name) lidC)) in

  let convert_oneind mip =
      let (_,arity) = decomp_n_prod evd nparams (body_of_type mip.mINDARITY) in
         Node((0,0),"VERNACARGLIST",
            [nvar(string_of_id mip.mINDTYPENAME);
             ope("COMMAND", [bdize_no_casts true lparsprint arity]);
             ope("BINDERLIST", convert_env (List.rev lpars));
             convert_constructor mip]) in
      
      (ope("MUTUALINDUCTIVE",
         [(str(if mipv.(0).mINDFINITE then 
                 "Inductive"
               else
                 "CoInductive"));
           ope("VERNACARGLIST",
             (List.map convert_oneind (Array.to_list mipv)))])::
         (implicit_args_to_ast_list mipv));;


(* When printing data, bdize_no_casts does not care about producing a term
   where coercion functions are hidden.  This is taken care of by printing rules
   that are automatically produced when defining the coercions.  This approach
   is not valid for us and use this function do remove coercion functions. *)

let defined_as_coercion = function
    Node(_, "CONST",(Path(_,section_path,k)::_)) ->
      (try
          let _,{cOE_PARAM=p} = coercion_info (NAM_SP (Names.section_path
                                                         section_path k)) in
          Some p
      with Not_found -> None)
  | Node(_,"MUTCONSTRUCT",[Path(_, section_path,k);Num(_, tyi);
                             Num(_, i)]) ->
      (try
          let _,{cOE_PARAM=p} = 
                    coercion_info (NAM_Construct ((Names.section_path
                                                    section_path k),tyi,i)) in
          Some p
      with Not_found -> None)
  | _ -> None;;

let rec nth_tl l n = if n = 0 then l
 else (match l with
 | a :: b -> nth_tl b (n - 1)
 | [] -> failwith "list too short for nth_tl");;

let rec discard_coercions =
 function
    | Slam (l, na, ast) -> Slam (l, na, discard_coercions ast)
    | Node (l, ("APPLIST" as nna), (f :: args as all_sons)) ->
     (match defined_as_coercion f with
     | Some n ->
      let new_args =
       try nth_tl args n
       with
       | Failure "list too short for nth_tl" -> [] in
      (match new_args with
       | a :: (b :: c) -> Node (l, nna, List.map discard_coercions new_args)
       | a :: [] -> discard_coercions a
       | [] -> Node (l, nna, List.map discard_coercions all_sons))
     | None -> Node (l, nna, List.map discard_coercions all_sons))
    | Node (l, nna, all_sons) ->
     Node (l, nna, List.map discard_coercions all_sons)
    | it -> it;;

let constr_to_ast v = 
   (discard_coercions (bdize_no_casts true (gLOB (initial_sign())) v));;

let implicits_to_ast_list implicits =
    (match (impl_args_to_string implicits) with
                  None -> []
                | Some s -> [ope("COMMENT", [str s])]);;

let make_variable_ast name typ implicits =
   (ope("VARIABLE",
    [str "VARIABLE";
     ope("BINDERLIST",
         [ope("BINDER",
            [(constr_to_ast (body_of_type typ));
             nvar name])])]))::(implicits_to_ast_list implicits)
    ;;
    
let leaf_entry_to_ast_list (sp,lobj) =
  let tag = object_tag lobj in
  match (sp,tag) with
  | (_, "VARIABLE") ->
      let (name, (typ,_),_,l,_,_) = outVariable lobj in
        make_variable_ast (string_of_id name) typ (list_of_implicits l)
  | (_, "CONSTANT") ->
      let (cmap,_,_) = outConstant lobj in
      if Listmap.in_dom cmap CCI then
        let {cONSTBODY=val_O;cONSTTYPE=typ;cONSTIMPARGS=l} 
              = Listmap.map cmap CCI in
                (match val_O with
                 | Some{contents=COOKED c} -> (ope("DEFINITION",
                            [str "DEFINITION";
                             nvar(string_of_id (basename (ccisp_of sp)));
                             ope("COMMAND",
                              [ope("CAST",
                                [(constr_to_ast c);
				 (constr_to_ast (body_of_type typ))])])]))::
                         (implicits_to_ast_list (list_of_implicits l))
                 | _ -> make_variable_ast
                              (string_of_id (basename (ccisp_of sp)))
                               typ
                               (list_of_implicits l))
        else
         failwith "leaf_entry_to_ast_list : FW unexpected"
  | (sp, "MUTUALINDUCTIVE") ->
    let (cmap,_) = outMutualInductive lobj in
    if Listmap.in_dom cmap CCI then
       mutual_to_ast_list (Listmap.map cmap CCI)
    else
       failwith "leaf_entry_to_ast_list : FW unexpected"


  | (sp,s) -> failwith ("leaf_entry_to_ast_list : " ^ (string_of_path sp) ^
              " unrecognized object : " ^s);;

let name_to_ast name = 
  let str = string_of_id name in
    try let sp = Nametab.sp_of_id CCI name in
        let lobj = Lib.map_leaf (objsp_of sp) in
        ope("vernac_list", leaf_entry_to_ast_list (sp, lobj))
    with 
    | Not_found ->
        (try
           let typ = snd(lookup_glob name (gLOB (initial_sign ()))) in
           ope("vernac_list",
               (make_variable_ast str typ (Vartab.implicits_of_var CCI name)))
         with
            Not_found | Invalid_argument _ -> error (str ^ " is not defined"))
    | Invalid_argument _ -> error (str ^ " is not defined");;
