(**************************************************************************
  *********                  ntpprinter.mli                       *********
  **************************************************************************)
open Ntdef;;
open Pp;;
open Term;;
open Names;;

val s' : string -> std_ppcmds;;

val h' : std_ppcmds -> std_ppcmds;;

val v' : std_ppcmds -> std_ppcmds;;

val pr_nc : natural_constr -> std_ppcmds;;

val pr_c : constr -> std_ppcmds;;

val p_formula : (constr -> std_ppcmds) ref;;

val pr_name : name -> std_ppcmds;;

type pp_rule = (natural_constr -> std_ppcmds) ref;;

(**
  ** common **
  *
  dots *)
val p_dot_top : pp_rule;;

val p_dot_mid : pp_rule;;

val p_dot_dot : pp_rule;;

val p_dot : (int -> natural_constr -> std_ppcmds) ref;;

val p_indent : pp_rule;;

(*extract annotation *)
val p_lambda_binder_type : pp_rule;;

val p_case_number : pp_rule;;

val p_nbr_cases : pp_rule;;

val p_induct_cst :
      ((constr -> std_ppcmds) ref -> natural_constr -> std_ppcmds) ref;;

val p_cst : (constr -> std_ppcmds) ref;;

val p_fix_case_name : pp_rule;;

val p_fix_case_type : pp_rule;;

val p_type_1 : pp_rule;;

val p_type_2 : pp_rule;;

val p_type_3 : pp_rule;;

val p_type_1_bis : pp_rule;;

val p_type_2_bis : pp_rule;;

val p_type_3_bis : pp_rule;;

(** complete text rules *
  head *)
val p_apply_head_vert : pp_rule;;

val p_elim_head_vert : pp_rule;;

(*body *)
val p_lambda_body : pp_rule;;

val p_apply_body : pp_rule;;

val p_elim_body : pp_rule;;

val p_fix_body : pp_rule;;

val p_misc_body : pp_rule;;

(*incomplete text rule *)
val p_lambda_var_list : pp_rule;;

val p_lambda_var_list_hyp : pp_rule;;

val p_lambda_son : (pp_rule -> natural_constr -> std_ppcmds) ref;;

val p_apply_head : (pp_rule -> natural_constr -> std_ppcmds) ref;;

val p_apply_sub_horiz : pp_rule;;

val p_apply_sub_horiz_cap : pp_rule;;

val p_apply_sub_horiz_expl : pp_rule;;

val p_elim_head : (pp_rule -> natural_constr -> std_ppcmds) ref;;

(*text format *)
val p_text_intro : pp_rule;;

val p_text_head : pp_rule;;

val p_text_body : pp_rule;;

val p_text_concl : pp_rule;;

val p_all : pp_rule;;

(*top_level *)
val p_definition : (nt_definition -> std_ppcmds) ref;;

(**
  ** each language **
  *
  misc *)
val p_text_and : pp_rule;;

val p_text_theorem : (string -> std_ppcmds) ref;;

val p_text_definition : (string -> std_ppcmds) ref;;

val p_text_axiom : (string -> std_ppcmds) ref;;

val p_text_type : (string -> std_ppcmds) ref;;

val p_text_statement : (string -> std_ppcmds) ref;;

val p_text_proof : (string -> std_ppcmds) ref;;

val p_text_qed : (string -> std_ppcmds) ref;;

val p_text_int : (int -> std_ppcmds) ref;;

val text_of_int : (int -> string) ref;;

val p_type_formula : (constr -> std_ppcmds) ref;;

val p_type_formula_bis : (constr -> std_ppcmds) ref;;

val p_type_intro : pp_rule;;

val p_type_intro_cap : pp_rule;;

val p_type_intro_bis : pp_rule;;

val p_type_intro_bis_cap : pp_rule;;

val p_type_concl : pp_rule;;

val p_type_concl_bis : pp_rule;;

val p_type_concl_ter : pp_rule;;

(*identifiers *)
val p_id : pp_rule;;

val p_id_expl : pp_rule;;

val p_id_cap : pp_rule;;

(*definitions *)
val p_definition_expl : (constr -> std_ppcmds) ref;;

val p_definition_cap : (constr -> std_ppcmds) ref;;

(*introduction *)
val p_elim_case_intro : pp_rule;;

val p_fix_case_intro : pp_rule;;

val p_lambda_intro : pp_rule;;

val p_lambda_type : pp_rule;;

val p_lambda_type_next : pp_rule;;

val p_lambda_type_list : pp_rule;;

val p_lambda_sort : pp_rule;;

val p_lambda_sort_cap : pp_rule;;

val p_lambda_sort_next : pp_rule;;

val p_lambda_sort_list : pp_rule;;

val p_lambda_sort_list_cap : pp_rule;;

val p_lambda_sort_bis : pp_rule;;

val p_lambda_sort_next_bis : pp_rule;;

val p_lambda_sort_list_bis : pp_rule;;

val p_apply_std_intro : pp_rule;;

val p_apply_omit_intro : pp_rule;;

val p_apply_construct_intro : pp_rule;;

val p_elim_match_intro : pp_rule;;

val p_elim_match_one_intro : pp_rule;;

val p_elim_match_absurd_intro : pp_rule;;

val p_elim_induc_intro : pp_rule;;

val p_trivial_intro : pp_rule;;

val p_misc_intro : pp_rule;;

(*conclusions *)
val p_lambda_concl : pp_rule;;

val p_apply_std_concl : pp_rule;;

val p_apply_std_specialization_concl : pp_rule;;

val p_apply_omit_concl : pp_rule;;

val p_apply_omit_specialization_concl : pp_rule;;

val p_apply_construct_concl : pp_rule;;

val p_apply_construct_specialization_concl : pp_rule;;

val p_elim_match_concl : pp_rule;;

val p_elim_match_no_case_concl : pp_rule;;

val p_elim_match_one_concl : pp_rule;;

val p_elim_match_absurd_concl : pp_rule;;

val p_elim_match_trivial_concl : pp_rule;;

val p_elim_induc_concl : pp_rule;;

val p_fix_concl : pp_rule;;

val p_identifier_concl : pp_rule;;

val p_metavar_concl : pp_rule;;

val p_trivial_concl : pp_rule;;

val p_misc_concl : pp_rule;;

