(**************************************************************************
  *********                  ntpprinter.ml                        *********
  **************************************************************************)
open Pp;;
open Names;;
open Printer;;
open More_util;;
open Tutil;;
open Ntdef;;

type pp_rule = (natural_constr -> std_ppcmds) ref;;

let s' str =
 let inc i = i:=!i + 1 in
 let l = String.length str in
 let i = ref 0 in
 let j = ref 0 in
 let s = ref [] in
 while !j < l do while !i < l & str.[!i] <> ' ' do inc i done;
                 s:=(if !i < l then (if !i = !j then sPC::!s
                  else sPC::sTR (String.sub str !j (!i - !j))::!s)
                  else sTR (String.sub str !j (l - !j))::!s);
                 inc i;
                 j:=!i done; Stream.of_list (List.rev !s);;

let h' strm = hOV 4 strm;;

let v' strm = v 0 strm;;

let pr_nc nc = prterm (c_of_nc (from_VAR_to_Rel nc));;

let pr_c c = prterm (c_of_nc (from_VAR_to_Rel (nc_of_c c)));;

let p_formula = ref pr_c;;

let pr_name =
 function
    | Name id -> [< 'sTR (string_of_id id) >]
    | Anonymous -> [< 'sTR "_" >];;

(**
  ** common **
  *
  dots *)
let p_dot_top = ref (function _ -> [< 'sTR "UNDEF p_dot_top" >]);;

let p_dot_mid = ref (function _ -> [< 'sTR "UNDEF p_dot_mid" >]);;

let p_dot_dot = ref (function _ -> [< 'sTR "UNDEF p_dot_dot" >]);;

let p_dot = ref (fun _ _ -> [< 'sTR "UNDEF [_dot" >]);;

let p_indent = ref (function _ -> [< 'sTR "UNDEF p_indent" >]);;

(*extract annotation *)
let p_lambda_binder_type =
 ref (function _ -> [< 'sTR "UNDEF p_lambda_binder_type" >]);;

let p_extract_case_number =
 ref (function _ -> [< 'sTR "UNDEF p_extract_case_number" >]);;

let p_case_number = ref (function _ -> [< 'sTR "UNDEF p_case_number" >]);;

let p_nbr_cases = ref (function _ -> [< 'sTR "UNDEF p_nbr_cases" >]);;

let p_induct_cst = ref (fun _ _ -> [< 'sTR "UNDEF p_induct_cst" >]);;

let p_cst = ref (function _ -> [< 'sTR "UNDEF p_cst" >]);;

let p_fix_case_name = ref (function _ -> [< 'sTR "UNDEF p_fix_case_name" >]);;

let p_fix_case_type = ref (function _ -> [< 'sTR "UNDEF p_fix_case_type" >]);;

let p_type_1 = ref (function _ -> [< 'sTR "UNDEF p_type_1" >]);;

let p_type_2 = ref (function _ -> [< 'sTR "UNDEF p_type_2" >]);;

let p_type_3 = ref (function _ -> [< 'sTR "UNDEF p_type_3" >]);;

let p_type_1_bis = ref (function _ -> [< 'sTR "UNDEF p_type_1_bis" >]);;

let p_type_2_bis = ref (function _ -> [< 'sTR "UNDEF p_type_2_bis" >]);;

let p_type_3_bis = ref (function _ -> [< 'sTR "UNDEF p_type_3_bis" >]);;

(** complete text rules *
  head *)
let p_apply_head_vert = ref (function _ -> [< 'sTR "UNDEF p_apply_head_vert" >]);;

let p_elim_head_vert = ref (function _ -> [< 'sTR "UNDEF p_elim_head_vert" >]);;

(*body *)
let p_lambda_body = ref (function _ -> [< 'sTR "UNDEF p_lambda_body" >]);;

let p_apply_body = ref (function _ -> [< 'sTR "UNDEF p_apply_body" >]);;

let p_elim_body = ref (function _ -> [< 'sTR "UNDEF p_elim_body" >]);;

let p_elim_one_body = ref (function _ -> [< 'sTR "UNDEF p_elim_one_body" >]);;

let p_fix_body = ref (function _ -> [< 'sTR "UNDEF p_fix_body" >]);;

let p_misc_body = ref (function _ -> [< 'sTR "UNDEF p_misc_body" >]);;

(*incomplete text rule *)
let p_lambda_var_list = ref (function _ -> [< 'sTR "UNDEF p_lambda_var_list" >]);;

let p_lambda_var_list_hyp =
 ref (function _ -> [< 'sTR "UNDEF p_lambda_var_list_hyp" >]);;

let p_lambda_son = ref (fun _ _ -> [< 'sTR "UNDEF p_lambda_son" >]);;

let p_apply_head = ref (fun _ _ -> [< 'sTR "UNDEF p_apply_head" >]);;

let p_apply_sub_horiz = ref (function _ -> [< 'sTR "UNDEF p_apply_sub_horiz" >]);;

let p_apply_sub_horiz_cap =
 ref (function _ -> [< 'sTR "UNDEF p_apply_sub_horiz_cap" >]);;

let p_apply_sub_horiz_expl =
 ref (function _ -> [< 'sTR "UNDEF p_apply_sub_horiz_expl" >]);;

let p_elim_head = ref (fun _ _ -> [< 'sTR "UNDEF p_elim_head" >]);;

(*text format *)
let p_text_intro = ref (function _ -> [< 'sTR "UNDEF p_text_intro" >]);;

let p_text_head = ref (function _ -> [< 'sTR "UNDEF p_text_head" >]);;

let p_text_body = ref (function _ -> [< 'sTR "UNDEF p_text_body" >]);;

let p_text_concl = ref (function _ -> [< 'sTR "UNDEF p_text_concl" >]);;

let p_all = ref (function _ -> [< 'sTR "UNDEF p_all" >]);;

let p_definition = ref (function _ -> [< 'sTR "UNDEF p_definition" >]);;

(*top_level *)
(**
  ** each language **
  *
  misc *)
let p_text_and = ref (function _ -> [< 'sTR "UNDEF p_text_and" >]);;

let p_text_theorem = ref (function _ -> [< 'sTR "UNDEF p_text_theorem" >]);;

let p_text_definition = ref (function _ -> [< 'sTR "UNDEF p_text_definition" >]);;

let p_text_axiom = ref (function _ -> [< 'sTR "UNDEF p_text_axiom" >]);;

let p_text_type = ref (function _ -> [< 'sTR "UNDEF p_text_type" >]);;

let p_text_statement = ref (function _ -> [< 'sTR "UNDEF p_text_statement" >]);;

let p_text_proof = ref (function _ -> [< 'sTR "UNDEF p_text_proof" >]);;

let p_text_qed = ref (function _ -> [< 'sTR "UNDEF p_text_qed" >]);;

let p_text_int = ref (function i -> [< 'sTR (string_of_int i) >]);;

let text_of_int = ref (function i -> string_of_int i);;

let p_type_formula = ref (function _ -> [< 'sTR "UNDEF p_type_formula" >]);;

let p_type_formula_bis = ref (function _ -> [< 'sTR "UNDEF p_type_formula_bis" >]);;

let p_type_intro = ref (function _ -> [< 'sTR "UNDEF p_type_intro" >]);;

let p_type_intro_cap = ref (function _ -> [< 'sTR "UNDEF p_type_intro_cap" >]);;

let p_type_intro_bis = ref (function _ -> [< 'sTR "UNDEF p_type_intro_bis" >]);;

let p_type_intro_bis_cap =
 ref (function _ -> [< 'sTR "UNDEF p_type_intro_bis_cap" >]);;

let p_type_concl = ref (function _ -> [< 'sTR "UNDEF p_type_concl" >]);;

let p_type_concl_bis = ref (function _ -> [< 'sTR "UNDEF p_type_concl_bis" >]);;

let p_type_concl_ter = ref (function _ -> [< 'sTR "UNDEF p_type_concl_ter" >]);;

(*identifiers *)
let p_id = ref (function _ -> [< 'sTR "UNDEF p_id" >]);;

let p_id_expl = ref (function _ -> [< 'sTR "UNDEF p_id_expl" >]);;

let p_id_cap = ref (function _ -> [< 'sTR "UNDEF p_id_cap" >]);;

(*definitions *)
let p_definition_expl =
 ref (function _ -> [< 'sTR "UNDEF p_definition_cst_expl" >]);;

let p_definition_cap = ref (function _ -> [< 'sTR "UNDEF p_definition_cst_cap" >]);;

(*introduction *)
let p_elim_case_intro = ref (function _ -> [< 'sTR "UNDEF p_elim_case_intro" >]);;

let p_fix_case_intro = ref (function _ -> [< 'sTR "UNDEF p_fix_case_intro" >]);;

let p_lambda_intro = ref (function _ -> [< 'sTR "UNDEF p_lambda_intro" >]);;

let p_lambda_type = ref (function _ -> [< 'sTR "UNDEF p_lambda_type" >]);;

let p_lambda_type_next = ref (function _ -> [< 'sTR "UNDEF p_lambda_type_next" >]);;

let p_lambda_type_list = ref (function _ -> [< 'sTR "UNDEF p_lambda_type_list" >]);;

let p_lambda_sort = ref (function _ -> [< 'sTR "UNDEF p_lambda_sort" >]);;

let p_lambda_sort_cap = ref (function _ -> [< 'sTR "UNDEF p_lambda_sort_cap" >]);;

let p_lambda_sort_next = ref (function _ -> [< 'sTR "UNDEF p_lambda_sort_next" >]);;

let p_lambda_sort_list = ref (function _ -> [< 'sTR "UNDEF p_lambda_sort_list" >]);;

let p_lambda_sort_list_cap =
 ref (function _ -> [< 'sTR "UNDEF p_lambda_sort_list_cap" >]);;

let p_lambda_sort_bis = ref (function _ -> [< 'sTR "UNDEF p_lambda_sort_bis" >]);;

let p_lambda_sort_next_bis =
 ref (function _ -> [< 'sTR "UNDEF p_lambda_sort_next_bis" >]);;

let p_lambda_sort_list_bis =
 ref (function _ -> [< 'sTR "UNDEF p_lambda_sort_list_bis" >]);;

let p_apply_std_intro = ref (function _ -> [< 'sTR "UNDEF p_apply_std_intro" >]);;

let p_apply_omit_intro = ref (function _ -> [< 'sTR "UNDEF p_apply_omit_intro" >]);;

let p_apply_construct_intro =
 ref (function _ -> [< 'sTR "UNDEF p_apply_construct_intro" >]);;

let p_elim_match_intro = ref (function _ -> [< 'sTR "UNDEF p_elim_match_intro" >]);;

let p_elim_match_one_intro =
 ref (function _ -> [< 'sTR "UNDEF p_elim_match_one_intro" >]);;

let p_elim_match_absurd_intro =
 ref (function _ -> [< 'sTR "UNDEF p_elim_match_absurd_intro" >]);;

let p_elim_induc_intro = ref (function _ -> [< 'sTR "UNDEF p_elim_induc_intro" >]);;

let p_elim_one_intro = ref (function _ -> [< 'sTR "UNDEF p_elim_one_intro" >]);;

let p_elim_one_lambda_intro =
 ref (function _ -> [< 'sTR "UNDEF p_elim_one_lambda_intro" >]);;

let p_trivial_intro = ref (function _ -> [< 'sTR "UNDEF p_trivial_intro" >]);;

let p_misc_intro = ref (function _ -> [< 'sTR "UNDEF p_misc_intro" >]);;

(*conclusions *)
let p_lambda_concl = ref (function _ -> [< 'sTR "UNDEF p_lambda_concl" >]);;

let p_apply_std_concl = ref (function _ -> [< 'sTR "UNDEF p_apply_std_concl" >]);;

let p_apply_std_specialization_concl =
 ref (function _ -> [< 'sTR "UNDEF p_apply_std_specialization_concl" >]);;

let p_apply_omit_concl = ref (function _ -> [< 'sTR "UNDEF p_apply_omit_concl" >]);;

let p_apply_omit_specialization_concl =
 ref (function _ -> [< 'sTR "UNDEF p_apply_omit_specialization_concl" >]);;

let p_apply_construct_concl =
 ref (function _ -> [< 'sTR "UNDEF p_apply_construct_concl" >]);;

let p_apply_construct_specialization_concl =
 ref (function _ -> [< 'sTR "UNDEF p_apply_construct_specialization_concl" >]);;

let p_elim_match_concl = ref (function _ -> [< 'sTR "UNDEF p_elim_match_concl" >]);;

let p_elim_match_no_case_concl =
 ref (function _ -> [< 'sTR "UNDEF p_elim_match_no_case_concl" >]);;

let p_elim_match_one_concl =
 ref (function _ -> [< 'sTR "UNDEF p_elim_match_one_concl" >]);;

let p_elim_match_absurd_concl =
 ref (function _ -> [< 'sTR "UNDEF p_elim_match_absurd_concl" >]);;

let p_elim_match_trivial_concl =
 ref (function _ -> [< 'sTR "UNDEF p_elim_match_trivial_concl" >]);;

let p_elim_induc_concl = ref (function _ -> [< 'sTR "UNDEF p_elim_induc_concl" >]);;

let p_elim_one_concl = ref (function _ -> [< 'sTR "UNDEF p_elim_one_concl" >]);;

let p_elim_one_lambda_concl =
 ref (function _ -> [< 'sTR "UNDEF p_elim_one_lambda_concl" >]);;

let p_elim_one_lambda_trivial_concl =
 ref (function _ -> [< 'sTR "UNDEF p_elim_one_lambda_trivial_concl" >]);;

let p_fix_concl = ref (function _ -> [< 'sTR "UNDEF p_fix_concl" >]);;

let p_identifier_concl = ref (function _ -> [< 'sTR "UNDEF p_identifier_concl" >]);;

let p_metavar_concl = ref (function _ -> [< 'sTR "UNDEF p_metavar_concl" >]);;

let p_trivial_concl = ref (function _ -> [< 'sTR "UNDEF p_trivial_concl" >]);;

let p_misc_concl = ref (function _ -> [< 'sTR "UNDEF p_misc_concl" >]);;

