(**************************************************************************
  *********                         ntcount.ml                    *********
  **************************************************************************)
open Generic;;
open More_util;;
open Std;;
open Ntdef;;
open Ntaux;;
open Ntsons;;

(**************************************************************************
  **                               count                                 **
  **************************************************************************)
let f_id =
 function
    | true -> Nii_id false
    | false -> Nii_not;;

let rec is_trivial i nc =
 match nc_get_n_i nc with
 | Ni_id _ -> nc_body nc = Rel i
 | Ni_lambda (_, _, (_, (Nln_triv, _))) -> true
 | Ni_app (data, (Nauc_elim (_, (_, _, (0, _, 0))))) ->
  let head = nc_elim_head nc in
  nc_get_n_j head = None & nc_body head = Rel i
 | Ni_lambda (_, _, (_, (Nln_noocc, _))) ->
  is_trivial (i + 1) (nc_lambda_son nc)
 | _ -> false;;

let compute_elim_case_nat nc =
 match nc_get_n_a nc with
 | Na_app_son (_, _, (Nase_case (_, None, _, _, _))) ->
  (match nc_get_n_i nc with
  | Ni_lambda (_, _, (_, (Nln_triv, _))) -> Ncn_triv
  | Ni_lambda (_, _, (_, ((Nln_not | Nln_abs), _))) -> Ncn_abs
  | _ -> Ncn_std)
 | Na_app_son (_, _, (Nase_case (_, (Some false), _, _, _))) -> Ncn_base
 | Na_app_son (_, _, (Nase_case (_, (Some true), _, _, _))) -> Ncn_induc
 | _ -> Ncn_std;;

let nc_loc_count nc =
 match nc_get_n_i nc with
 | Ni_app (data, (Nauc_apply (use, _))) ->
  let f_id =
   function
      | true -> Nii_id false
      | false -> Nii_not in
  let id_h = f_id (nc_is_identifier (nc_apply_head nc))
  and n_id_subs =
   let id_right, n_right =
    let rec f_apply_args l =
     match l with
     | nc :: l ->
      let id_right, n_right = f_apply_args l in
      (match nc_get_n_a nc with
       | Na_app_son (_, (Nasa_sub (None, _)), elim_arg) ->
        let n_a = Na_app_son (true, Nasa_sub (None, n_right), elim_arg) in
        nc_set_n_a n_a nc; id_right & nc_is_identifier nc, n_right + 1
       | Na_app_son (_, (Nasa_sub ((Some (id, n) as recur), _)), elim_arg) ->
        let n_a = Na_app_son (true, Nasa_sub (recur, n_right), elim_arg) in
        nc_set_n_a n_a nc; id_right & id <> Nii_not, n_right + n
       | _ -> id_right, n_right)
     | [] -> true, 0 in
    f_apply_args (nc_apply_subs nc) in
   f_id id_right, n_right in
  let tag_head =
   let head = nc_apply_head nc in
   match nc_get_n_a head with
    | Na_app_son (_, apply_arg, elim_arg) ->
     let n_a = Na_app_son (true, apply_arg, elim_arg) in
     nc_set_n_a n_a head
    | _ -> () in
  let n_i = Ni_app (data, Nauc_apply (use, 
                           (id_h, n_id_subs))) in
  nc_set_n_i n_i nc
 | Ni_app (data, (Nauc_elim ((induc, omit as use), _))) ->
  let is_id =
   let head = nc_elim_head nc in
   let is_id =
    match nc_get_n_a head with
    | Na_app_son (_, _, (Nase_destruct true)) -> true
    | _ -> nc_is_identifier head in
   f_id is_id in
  let n1 = ref 0
  and n2 = ref 0
  and n3 = ref 0 in
  begin
    let f_elim_case nc =
     match nc_get_n_a nc with
     | Na_app_son (_, data_apply, (Nase_case (true, _, _, _, _) as data_elim)) ->
      (match nc_lambda_son nc with
       | DOP1 ((Inr ({n_i=Ni_app (_, (Nauc_elim (_, (_, _, (n1', n2', n3')))))})),
                 _) ->
        n1:=!n1 + n1';
        n2:=!n2 + n2';
        n3:=!n3 + n3'
       | _ -> ()); nc_set_n_a (Na_app_son (false, data_apply, data_elim)) nc
     | Na_app_son (_, data_apply, (Nase_case (false, induc, n_lamb, _, num))) ->
      let nat = compute_elim_case_nat nc in
      (match nat with
       | Ncn_std | Ncn_base -> n1:=!n1 + 1
       | Ncn_triv | Ncn_induc -> n2:=!n2 + 1
       | Ncn_abs -> n3:=!n3 + 1);
      nc_set_n_a
       (Na_app_son
       (false, data_apply, Nase_case (false, induc, n_lamb, nat, num))) nc
     | _ -> () in
    List.iter f_elim_case (nc_elim_cases nc)
  end;
   let count = is_id, !n1 + !n2 + !n3, 
    (!n1, !n2, !n3) in
   let tag_head =
    let head = nc_elim_head nc in
    match nc_get_n_a head with
     | Na_app_son (_, apply_arg, elim_arg) ->
      let n_a = Na_app_son (false, apply_arg, elim_arg) in
      nc_set_n_a n_a head
     | _ -> () in
   let n_i = Ni_app (data, Nauc_elim (use, count)) in
   nc_set_n_i n_i nc
 | Ni_lambda ((_, occ, _ as data), data_elim, ((_, link, _ as use), _)) -> begin
                                                                             let
                                                                             son
                                                                              =
                                                                              nc_lambda_son
                                                                              nc
                                                                             and noocc
                                                                              =
                                                                              occ
                                                                               =
                                                                               (No0,
                                                                               No0)
                                                                             in
                                                                             let
                                                                             nat
                                                                              =
                                                                              if
                                                                              is_trivial
                                                                              1
                                                                              son
                                                                              then
                                                                              Nln_triv
                                                                              else
                                                                              (match
                                                                                nc_get_n_i
                                                                                 son,
                                                                                noocc,
                                                                                nc_is_type_used
                                                                                 son
                                                                                with
                                                                              | (Ni_app (_,
                                                                                           (Nauc_elim (_,
                                                                                                         (_, _,
                                                                                                            (0, 0,
                                                                                                               _)))))), _,
                                                                                  _ ->
                                                                               Nln_abs
                                                                              | (Ni_lambda (_, _,
                                                                                              (_,
                                                                                                 (Nln_triv,
                                                                                                    _)))), true,
                                                                                  false ->
                                                                               Nln_triv
                                                                              | (Ni_lambda (_, _,
                                                                                              (_,
                                                                                                 (Nln_not,
                                                                                                    _)))), _,
                                                                                  false ->
                                                                               Nln_not
                                                                              | (Ni_lambda (_, _,
                                                                                              (_,
                                                                                                 (Nln_abs,
                                                                                                    _)))), _,
                                                                                  false ->
                                                                               Nln_abs
                                                                              | _ ->
                                                                               if
                                                                                nc_is_concl_false
                                                                                son
                                                                                then
                                                                                Nln_not
                                                                                else
                                                                                if
                                                                                noocc
                                                                                then
                                                                                Nln_noocc
                                                                                else
                                                                                Nln_std)
                                                                             and link_count
                                                                             =
                                                                              match
                                                                               nc_get_n_i
                                                                               son
                                                                               with
                                                                              | Ni_lambda (_, _,
                                                                                             (_,
                                                                                                (_,
                                                                                                   (typ, sort,
                                                                                                      sentence)))) ->
                                                                               (match
                                                                                link
                                                                                with
                                                                               | Nll_type ->
                                                                                typ
                                                                                 +
                                                                                 1,
                                                                                 sort,
                                                                                 sentence
                                                                               | Nll_sort ->
                                                                                0,
                                                                                 sort
                                                                                  +
                                                                                  1,
                                                                                 sentence
                                                                               | Nll_sentence ->
                                                                                0,
                                                                                 0,
                                                                                 sentence
                                                                                  +
                                                                                  1
                                                                               | Nll_none ->
                                                                                0,
                                                                                 0,
                                                                                 0)
                                                                              | _ ->
                                                                               0,
                                                                                0,
                                                                                0
                                                                             in
                                                                             let
                                                                             n_i
                                                                              =
                                                                              Ni_lambda
                                                                              (data,
                                                                              data_elim,
                                                                              
                                                                              (use,
                                                                               
                                                                               (nat,
                                                                                link_count)))
                                                                             in
                                                                             nc_set_n_i
                                                                              n_i
                                                                              nc
                                                                           end;
 if nc_get_n_j nc <> None then (match nc with
  | DOP1 (_, (DOP2 (_, _, (DLAM (_, (DOP1 (_, (DOPN (_, v))))))))) ->
   Array.iter (function nc ->
    (match nc_get_n_a nc with
    | Na_app_son (_, data_apply, data_elim) ->
     nc_set_n_a (Na_app_son (false, data_apply, data_elim)) nc
    | _ -> ())) v
  | _ -> ())
 | _ -> ();;

(**************************************************************************
  **                       count immediate hyp                           **
  **************************************************************************)
let is_Rel_i i nc = nc_get_n_j nc = None & (match nc_body nc with
                     | Rel j -> i = j
                     | _ -> false);;

let rec check_immediate_hyp nc =
 match nc_get_n_i nc with
 | Ni_id (Nin_var _) ->
  let imm = is_Rel_i 1 nc in
  nc_set_n_i (Ni_id (Nin_var imm)) nc
 | Ni_app (_, (Nauc_apply ((_, (_, pos)), (id_head, (id_subs, n_subs))))) ->
  (match id_head, pos, id_subs, nc_rec_apply_subs nc with
  | _, _, _, [] -> check_immediate_hyp (nc_apply_head nc)
  | (Nii_id _), _, (Nii_id _), (sub :: _) ->
   check_immediate_hyp (nc_apply_head nc); check_immediate_hyp sub
  | _, Up, _, _ -> check_immediate_hyp (nc_apply_head nc)
  | _, Dn, _, (sub :: _) -> check_immediate_hyp sub)
 | Ni_app (_, (Nauc_elim _)) -> check_immediate_hyp (nc_elim_head nc)
 | _ -> ();;

let nc_loc_count_immediate_hyp nc =
 match nc_get_n_i nc with
 | Ni_lambda ((Ns_Prop, _, _), _, _) -> check_immediate_hyp (nc_lambda_son nc)
 | _ -> ();;

(**************************************************************************
  **                       count case number                             **
  **************************************************************************)
let rec count_case_number l nc =
 match nc_get_n_i nc with
 | Ni_app (_, (Nauc_elim (_, _))) ->
  count_case_number_cases l 1 (nc_rec_elim_cases nc);
 count_case_number l (nc_elim_head nc)
 | _ -> List.iter (count_case_number l) (nc_rec_sons nc)
and count_case_number_cases l i case_l =
 match case_l with
 | nc :: case_l ->
  (match nc_get_n_a nc with
  | Na_app_son (use, apply_son,
                  (Nase_case (induc, induc_elim, n_lamb, nat, (Some _)))) ->
   let case_number = Some (List.rev (i::l)) in
   let
   n_a =
    Na_app_son
    (use, apply_son, Nase_case (induc, induc_elim, n_lamb, nat, case_number)) in
   nc_set_n_a n_a nc;
    count_case_number_cases l (i + 1) case_l;
    count_case_number (i::l) nc
  | _ -> count_case_number_cases l i case_l; count_case_number l nc)
 | [] -> ();;

let nc_glob_count_case_number nc = count_case_number [] nc;;

