(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                Natural.v                                 *)
(****************************************************************************)

Declare ML Module "ntrefiner" "util" "tutil" "ntparam" "ntdef" "ntaux" 
  "ntsons" "nttrans" "ntpprinter" "ntformat" "ntdata" "ntuse" "ntcount" 
  "ppml" "ppaux" "ppenglish_aux" "ppenglish" "ppfrench_aux" "ppfrench" 
  "ppprooftext" "nttop" "ntcommand" "ntentries".


(***************************** Parsing of commands ************************)

Grammar vernac vernac :=
  nat_setlang [ "Set" "Natural" identarg($id) "."] ->
                [(SelectLanguageText $id)]

| nat_print [ "Print" "Natural" identarg($id) "."] ->
                [(PrintText $id)]

| nat_show [ "Show" "Natural" "Proof" "."] ->
                [(PrintCurrentText)]

| nat_default [ "Set" "Natural" "Default" "."] ->
                [(InitText)]

| nat_setdepth_num [ "Set" "Natural" "Depth" prim:number($n) "." ] ->
                [(SetDepth $n)]

| nat_setdepth [ "Set" "Natural" "Depth" "." ] ->
                [(SetDepth)].


Grammar vernac vernac :=
  nat_add_impl [ "Add" "Natural" "Implicit" identarg($id) "."] ->
                [(AddTextParamOmit $id)]

| nat_test_impl [ "Test" "Natural" "Implicit" identarg($id) "."] ->
                [(MemTextParamOmit $id)]

| nat_rem_impl [ "Remove" "Natural" "Implicit" identarg($id) "."] ->
                [(RemoveTextParamOmit $id)]

| nat_print_impl [ "Print" "Natural" "Implicit" "."] ->
                [(PrintTextParamOmit)].


Grammar vernac vernac :=
  nat_add_cont [ "Add" "Natural" "Contractible" identarg($id) "."] ->
                [(AddTextParamRecSub $id)]

| nat_test_cont [ "Test" "Natural" "Contractible" identarg($id) "."] ->
                [(MemTextParamRecSub $id)]

| nat_rem_cont [ "Remove" "Natural" "Contractible" identarg($id) "."] ->
                [(RemoveTextParamRecSub $id)]

| nat_print_cont [ "Print" "Natural" "Contractible" "."] ->
                [(PrintTextParamRecSub)].


Grammar vernac vernac :=
  nat_add_trans [ "Add" "Natural" "Transparent" identarg($id) "."] ->
                [(AddTextParamImmediate $id)]

| nat_test_trans [ "Test" "Natural" "Transparent" identarg($id) "."] ->
                [(MemTextParamImmediate $id)]

| nat_rem_trans [ "Remove" "Natural" "Transparent" identarg($id) "."] ->
                [(RemoveTextParamImmediate $id)]

| nat_print_trans [ "Print" "Natural" "Transparent" "."] ->
                [(PrintTextParamImmediate)].


(******************************* Initialization **************************)

Set Natural Default.

