(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                 ocaml.mli                                *)
(****************************************************************************)

(* Generated automatically by ocamlc -i *)

val print_typeid : Mlterm.typeid -> (int * string) Pp.ppcmd_token Stream.t
val collapse_type_app : Mlterm.mLtype list -> Mlterm.mLtype list
val ocaml_of_type : bool -> Mlterm.mLtype -> Pp.std_ppcmds
val ocaml_of_one_inductive :
  Names.identifier list * Names.identifier *
  (Names.identifier * Mlterm.mLtype list) list ->
  (int * string) Pp.ppcmd_token Stream.t
val ocaml_of_inductive :
  (Names.identifier list * Names.identifier *
   (Names.identifier * Mlterm.mLtype list) list)
  list -> (int * string) Pp.ppcmd_token Stream.t
val rename_bvars :
  Names.identifier list -> Names.identifier list -> Names.identifier list
val abst : Names.identifier list -> (int * string) Pp.ppcmd_token Stream.t
val pr_binding :
  Names.identifier list -> (int * string) Pp.ppcmd_token Stream.t
val pp_rel : Names.identifier list -> int -> string
val pp_mlast :
  Names.identifier list ->
  bool -> Pp.std_ppcmds list -> Mlterm.mLast -> Pp.std_ppcmds
val pp_mlfix :
  Names.identifier list ->
  bool ->
  int * bool * Names.identifier list * Mlterm.mLast list ->
  Pp.std_ppcmds list -> Pp.std_ppcmds
val pp_mlfunction :
  Names.identifier list ->
  Names.identifier -> Mlterm.mLast -> (int * string) Pp.ppcmd_token Stream.t
val pp_mlpat :
  Names.identifier list ->
  (Names.identifier * Names.identifier list * Mlterm.mLast) array ->
  (int * string) Pp.ppcmd_token Stream.t
val ocaml_of_decl : Mlterm.mLdecl -> (int * string) Pp.ppcmd_token Stream.t
val ocaml_of_env :
  Mlterm.mLdecl list -> (int * string) Pp.ppcmd_token Stream.t
module OCaml_renaming :
  sig
    val rename_type_parameter :
      Names.identifier list -> Names.name -> Names.identifier
    val rename_type : Names.identifier list -> Names.name -> Names.identifier
    val rename_term : Names.identifier list -> Names.name -> Names.identifier
    val rename_global_type :
      Names.identifier list -> Names.name -> Names.identifier
    val rename_global_constructor :
      Names.identifier list -> Names.name -> Names.identifier
    val rename_global_term :
      Names.identifier list -> Names.name -> Names.identifier
  end
module OCaml_pp : Genpp.MLPP
module OCaml_pp_file :
  sig
    module Translation :
      sig
        val ren_type_parameter :
          Names.identifier list -> Names.name -> Names.identifier
        val ren_type :
          Names.identifier list -> Names.name -> Names.identifier
        val ren_term :
          Names.identifier list -> Names.name -> Names.identifier
        val ren_global_type : Names.identifier -> Names.identifier
        val ren_global_constructor : Names.identifier -> Names.identifier
        val ren_global_term : Names.identifier -> Names.identifier
        val mltype_of_constr :
          Mlterm.typeid list -> Term.constr -> Mlterm.mLtype
        val isSet : Term.sorts Term.oper Generic.term -> bool
        val abbrev_of_constr :
          Term.constr -> Names.identifier list * Mlterm.mLtype
        val type_of_c :
          Mlterm.typeid list ->
          Term.environment ->
          Mlterm.mLtype list ->
          Term.sorts Term.oper Generic.term -> Mlterm.mLtype list
        val decl_of_one_inductive :
          Names.section_path * int ->
          Term.environment ->
          int ->
          Constrtypes.mutual_inductive_packet ->
          Names.identifier list * Names.identifier *
          (Names.identifier * Mlterm.mLtype list) list
        val decl_of_inductive :
          Names.section_path ->
          Constrtypes.mutual_inductive_body -> Mlterm.mLdecl
        val collect_n_lambda :
          int -> Mlterm.mLast -> Names.identifier list * int * Mlterm.mLast
        val mlast_of_constr :
          Names.identifier list ->
          Term.environment ->
          Mlterm.mLast list -> Term.constr -> Mlterm.mLast
        val mlast_of_fix :
          bool ->
          Names.identifier list ->
          Term.environment -> bool -> Term.constr -> Mlterm.mLast
        val mlpat_of_constr :
          Names.identifier list ->
          Names.section_path * int ->
          Mlterm.mLast array ->
          (Names.identifier * Names.identifier list * Mlterm.mLast) array
        val is_rec : 'a Term.oper Generic.term -> bool
        val axiom_type_msg : Names.identifier -> 'a
        val not_an_ML_type_msg : Names.identifier -> 'a
        val decl_of_constant :
          'a ->
          Names.section_path -> Constrtypes.constant_body -> Mlterm.mLdecl
        val decl_of_sp : 'a -> Names.section_path -> Mlterm.mLdecl
        val mlenv_of_fwenv :
          'a * bool -> Names.section_path list -> Mlterm.mLdecl list
      end
    val pp_recursive : Genpp.extraction_params -> Pp.std_ppcmds
    val write_extraction_file : string -> Genpp.extraction_params -> unit
    val write_extraction_module : Names.identifier -> unit
  end
