
(* AVL *)

Require Extraction.
Require Avl_prog.
ML Import Constant string == string : Set.
ML Import Inductive bool [ true false ] ==
  Inductive BOOL : Set := TRUE  : BOOL
                        | FALSE : BOOL.
ML Import Constant lt_string == lt_string : string->string->BOOL.
Link a := string.
Link inf_dec :=
  [x,y:string]Cases (lt_string x y) of
                TRUE => left
              | FALSE => right
              end.
Write Caml File "avl" [rot_d rot_g rot_gd insert].


(* Euclid *)

Reset Initial.
Require Extraction.
Require Euclid_prog.

Write Caml File "euclid" [ eucl_dev ].


(* Heapsort *)

Reset Initial.
Require Extraction.
Require Heap_prog.

ML Import Constant int == int : Set.
Link List_Dom := int.
ML Import Inductive bool [ true false ] ==
         Inductive BOOL : Set := TRUE  : BOOL
                               | FALSE : BOOL.
ML Import Constant lt_int == lt_int : int->int->BOOL.
Link inf_total :=
         [x,y:int]Cases (lt_int x y) of
                            TRUE => left
                          | FALSE => right
                          end.

Write Caml File "heapsort" [ heapsort ].
