(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                include.ml                                *)
(****************************************************************************)

(* We only assume that the variable COQTOP is set *)
let src_dir =
  let coqtop =
    try Sys.getenv "COQTOP"
    with Not_found -> "." in
  let srccoq = Filename.concat coqtop "src" in
  let src_dir =
    if Sys.file_exists srccoq then srccoq
    else begin
      print_endline ("Cannot find the sources in "^srccoq);
      print_string "Where are they ? ";
      Filename.concat (read_line ()) "src"
    end in
  let add_dir dl = Topdirs.dir_directory
                     (List.fold_left Filename.concat src_dir dl) in
    List.iter add_dir
      [ [ "config" ]; [ "lib"; "util" ]; [ "parsing" ]; [ "meta" ];
        [ "constr" ]; [ "typing" ]; [ "proofs" ]; [ "env" ]; [ "tactics" ] ];
    src_dir
;;
(* Now Coq_config.cmi is accessible *)
Topdirs.dir_directory Coq_config.camlp4lib;;

#use "top_printers.ml";;

#install_printer  (* identifier *) prid;;
#install_printer  (* section_path *)  prsp;;

(* parsing of terms *)

let parse_com   = Pcoq.parse_string Pcoq.Command.command;;
let parse_tac = Pcoq.parse_string Pcoq.Tactic.tactic;;

(* For compatibility reasons *)
let parse_ast = parse_com;;

(* build a term of type constr without type-checking or resolution of 
   implicit syntax *)

let raw_constr_of_string s 
    = Astterm.dbize_cci (Evd.mt_evd()) (unitize_env (gLOB (initial_sign()))) 
      (parse_ast s);;

let e s    = 
   (fconstruct   (Evd.mt_evd()) (initial_sign()) (parse_ast s));;
let infe s = 
   (infconstruct (Evd.mt_evd()) (initial_assumptions()) (parse_ast s));;

(* Get the current goal *)

let getgoal x = top_goal_of_pftreestate (get_pftreestate x);;

let get_nth_goal n = nth_goal_of_pftreestate n (get_pftreestate ());;
let current_goal () = get_nth_goal 1;;

let pf_e gl s = 
    (fconstruct   (project gl) (pf_hyps gl) (parse_ast s));;
   

(* $Id: base_include.ml,v 1.4 1999/11/30 19:25:45 mohring Exp $ *)
