(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                 GElim.v                                  *)
(****************************************************************************)

Require Export Equality.

Declare ML Module "Gelim".

Grammar tactic simple_tactic :=
  comp_gelim [ "CompGElim" identarg($id) ] -> [(InvElimClear $id)]

| comp_gelim_in [ "CompGElim" identarg($id) "in" ne_identarg_list($l) ]
                 -> [(InvElimIn $id ($LIST $l))]

| half_gelim [ "HalfGElim" identarg($id) ] -> [(InvElim $id)].

Syntax tactic level 0:
  GElim [(InvElimClear $id)] -> ["CompGElim " $id]
| GElimin [(InvElimIn $id ($LIST $l))]
    -> ["CompGElim " $id (CLAUSE ($LIST $l))]

| halfGElim [(InvElim $id)] -> ["HalfGElim " $id]

| useGElimlema [(UseGElimersionLemma $id $c)] -> ["GElim " $id [1 1] $c]
| useGElimlemain [(UseGElimersionLemmaIn $id $c ($LIST $l))]
    -> ["GElim " $id [1 1] $c (CLAUSE ($LIST $l))].

(* $Id: GElim.v,v 1.10 1999/06/29 07:47:57 loiseleu Exp $ *)
