(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                              tacentries.ml                               *)
(****************************************************************************)

(* Concrete syntax of the mathematical vernacular MV V2.6 *)


open Std;;
open Names;;
open Tacmach;;
open Himsg;;
open Pp;;

open Proof_trees;;
open Tactics;;
open Tacticals;;

let v_absurd        = hide_tactic "Absurd"        dyn_absurd;;
let v_contradiction = hide_tactic "Contradiction" dyn_contradiction;;
let v_reflexivity   = hide_tactic "Reflexivity"   dyn_reflexivity;;
let v_symmetry      = hide_tactic "Symmetry"      dyn_symmetry;;
let v_transitivity  = hide_tactic "Transitivity"  dyn_transitivity;;
let v_intro         = hide_tactic "Intro"         dyn_intro;;
let v_intro_move    = hide_tactic "IntroMove"     dyn_intro_move;;
let v_introsUntil   = hide_tactic "IntrosUntil"   dyn_intros_until;;
let v_tclIDTAC      = hide_tactic "Idtac"         dyn_tclIDTAC;;
let v_tclFAIL       = hide_tactic "Fail"          dyn_tclFAIL;;
let v_assumption    = hide_tactic "Assumption"    dyn_assumption;;
let v_exact         = hide_tactic "Exact"         dyn_exact;;
let v_reduce        = hide_tactic "Reduce"        dyn_reduce;;
let v_change        = hide_tactic "Change"        dyn_change;;
let v_constructor   = hide_tactic "Constructor"   dyn_constructor;;
let v_left          = hide_tactic "Left"          dyn_left;;
let v_right         = hide_tactic "Right"         dyn_right;;
let v_split         = hide_tactic "Split"         dyn_split;;
let v_clear         = hide_tactic "Clear"         dyn_clear;;
let v_move          = hide_tactic "Move"          dyn_move;;
let v_move_dep      = hide_tactic "MoveDep"       dyn_move_dep;;
let v_apply         = hide_tactic "Apply"         dyn_apply;;
let v_cutAndResolve = hide_tactic "CutAndApply"   dyn_cut_and_apply;;
let v_cut           = hide_tactic "Cut"           dyn_cut;;
let v_lettac        = hide_tactic "LetTac"        dyn_lettac;;
let v_generalize    = hide_tactic "Generalize"    dyn_generalize;;
let v_generalize_dep = hide_tactic "GeneralizeDep" dyn_generalize_dep;;
let v_specialize    = hide_tactic "Specialize"    dyn_new_hyp;;
let v_elim          = hide_tactic "Elim"          dyn_elim;;
let v_elimType      = hide_tactic "ElimType"      dyn_elim_type;;
let v_induction     = hide_tactic "Induction"     dyn_induct;;
let v_case          = hide_tactic "Case"          dyn_case;;
let v_caseType      = hide_tactic "CaseType"      dyn_case_type;;
let v_destruct      = hide_tactic "Destruct"      dyn_destruct;;
let v_fix           = hide_tactic "Fix"           dyn_mutual_fix;;
let v_cofix         = hide_tactic "Cofix"         dyn_mutual_cofix;;


(* 
   The following two lines have been cut and pasted from
   vernacentries.ml. They are the only verancular phrases which make
   vernacentries to depend on Tactics.ml, and they should disappear
   from this module one of these days. -- Eduardo (12/8/97).
*)

open Vernacinterp;;
open Pfedit;;
(* 
   The first one is a command that should be a tactic. It has been
   added by Christine to patch an error in the design of the proof
   machine, and enables to instantiate existential variables when
   there are no more goals to solve. It cannot be a tactic since 
   all tactics fail if there are no further goals to prove.
*)

vinterp_add("EXISTENTIAL",
	    function [VARG_NUMBER n; VARG_COMMAND c] -> 
              (fun () -> mutate (instantiate_pf_com n c))
              |  _  -> assert false);;

(* 
  The second is a stupid macro that should be replaced by ``Exact
   c. Save.'' all along the theories. 
*)

vinterp_add("PROOF",
	    function [VARG_COMMAND c] ->
              (fun () -> (* by (tactic_com exact c) *)
                   (* on experimente la synthese d'ise dans exact *)
                 by (dyn_exact [COMMAND c]); 
                 save_named true)
	      |   _  -> assert false);;

let print_subgoals () = if not(Initial.is_silent()) then 
  Vernacentries.show_open_subgoals_focused();;

vinterp_add
  ("SOLVE",
   function l -> 
    let (n,tcom) = match l with [VARG_NUMBER n;VARG_TACTIC tcom] -> (n,tcom)
		|  _  -> invalid_arg "SOLVE"
    in
     (fun () -> 
	(match Tacinterp.is_just_undef_macro tcom with
            Some id -> 
	      let msg =
 	     	if Pfedit.refining () then "undefined command or tactic"
	     	else "undefined command"
	      in error msg
	  | None -> ());
	solve_nth n (Tacinterp.vernac_interp tcom);
	print_subgoals();
(* in case a strict subtree was completed, 
   go back to the top of the prooftree *) 

	if subtree_solved () then 
	  (rev_mutate top_of_tree; print_subgoals()) 
     ))
     ;;


(* $Id: tacentries.ml,v 1.25 1999/11/08 15:21:24 mohring Exp $ *)






