(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                               nbtermdn.mli                               *)
(****************************************************************************)
open Generic;;
open Term;;
open More_util;;

type 'na args =
    {name_ord : 'na -> 'na -> int};;

type ('na,'a) t;;
type ('na,'a) frozen_t;;

val create : 'na args -> ('na,'a) t;;

val add : ('na,'a) t -> ('na * (constr * 'a)) -> unit;;
val rmv : ('na,'a) t -> 'na -> unit;;
val in_dn : ('na,'a) t -> 'na -> bool;;
val remap : ('na,'a) t -> 'na -> (constr * 'a) -> unit;;

val lookup : ('na,'a) t -> constr -> (constr * 'a) list;;
val app : (('na * (constr * 'a)) -> unit) -> ('na,'a) t -> unit;;

val dnet_depth : int ref;;

val freeze : ('na,'a) t -> ('na,'a) frozen_t;;
val unfreeze : ('na,'a) frozen_t -> ('na,'a) t -> unit;;
val empty : ('na,'a) t -> unit;;
val to2Lists : ('na,'a) t -> ('na * (Term.constr * 'a)) list * 
                             (Termdn.lbl option * 'a Btermdn.t) list

(* $Id: nbtermdn.mli,v 1.7 1999/06/29 07:47:41 loiseleu Exp $ *)
