type loc = int * int

type t =
    Node of loc * string * t list
  | Nvar of loc * string
  | Slam of loc * string option * t
  | Num of loc * int
  | Id of loc * string
  | Str of loc * string
  | Path of loc * string list* string
  | Dynamic of loc * Dyn.t

(* usage : [subst_meta bl ast] *)
(* for each binding (i,c_i) in bl, replace the metavar ?i
  by c_i in ast *)
val subst_meta : (int, t) Listmap.t -> t -> t

(* returns the list of metas occuring in the ast *)
val collect_metas : t -> int list
