(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                               summary.mli                                *)
(****************************************************************************)

open Names

type 'a summary_declaration =
    {freeze_function : unit -> 'a;
     unfreeze_function : 'a -> unit;
     init_function : unit -> unit}

val declare_summary : string -> 'a summary_declaration -> unit

type summary_vector

val freeze_summary : unit -> summary_vector
val unfreeze_summary : summary_vector -> unit

val freeze_to_key : section_path -> unit
val unfreeze_from_key : section_path -> unit
val find_latest : unit -> section_path
val unfreeze_latest : section_path -> unit

type frozen_t
val get_frozen_summaries : unit -> frozen_t
val set_frozen_summaries : frozen_t -> unit
val list_frozen_summaries : unit -> section_path list

val init_caches : unit -> unit

(* $Id: summary.mli,v 1.7 1999/10/29 23:19:16 barras Exp $ *)
