(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                bstack.mli                                *)
(****************************************************************************)

(* A bounded stack : if the depth is NONE, then there is depth limit *)

type 'a t;;
val create : int option -> 'a t;;
val set_depth : 'a t -> int option -> unit;;
val push : 'a t -> 'a -> unit;;
val app_push : 'a t -> ('a -> 'a) -> unit;;
val app_repl : 'a t -> ('a -> 'a) -> unit;;
val pop : 'a t -> 'a option;;
val top : 'a t -> 'a option;;
val is_empty : 'a t -> bool;;
val depth : 'a t -> int;;

(* $Id: bstack.mli,v 1.6 1999/06/29 07:47:14 loiseleu Exp $ *)
