(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA                        ENS-CNRS                *)
(*              Rocquencourt                        Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               Jul 10th 1997                              *)
(*                                                                          *)
(****************************************************************************)
(*                                pretty.mli                                *)
(****************************************************************************)

open Pp
open Names
open Term
open Reduction
open Constrtypes

val print_basename : section_path -> string
val print_basename_mind : section_path -> identifier -> string
val print_closed_sections : bool ref
val print_impl_args : int list -> std_ppcmds
val print_env : path_kind -> (name * constr) list -> std_ppcmds
val print_context : bool -> Lib.library_segment -> std_ppcmds
val print_library_entry : bool -> (section_path * Lib.node) -> std_ppcmds
val print_full_context : unit -> std_ppcmds
val print_full_context_typ : unit -> std_ppcmds
val print_crible : identifier -> unit
val print_sec_context : string -> std_ppcmds
val print_sec_context_typ : string -> std_ppcmds
val print_val : context -> judgement -> std_ppcmds
val print_type : context -> judgement -> std_ppcmds
val print_eval :
  reduction_function -> context -> judgement -> std_ppcmds
val implicit_args_msg : mutual_inductive_packet array -> std_ppcmds
val print_mutual : path_kind -> mutual_inductive_body -> std_ppcmds
val print_name : identifier -> std_ppcmds
val print_opaque_name : identifier -> std_ppcmds
val print_local_context : unit -> std_ppcmds
val print_extracted_name : identifier -> std_ppcmds
val print_extraction : unit -> std_ppcmds
val print_extracted_vars : unit -> std_ppcmds
val crible : (string -> unit assumptions -> constr -> unit) -> identifier ->
  unit
val inspect : int -> std_ppcmds

(* $Id: pretty.mli,v 1.9 1999/08/06 20:49:09 herbelin Exp $ *)
