(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                              constants.mli                               *)
(****************************************************************************)

open Names
open Generic
open Term
open Constrtypes
open Environ

val make_constant_body :
  path_kind -> bool -> context * judgement -> constant_body
val make_constant :
  bool -> (context * judgement) * (context * information) ->
    (path_kind * constant_body) list
val infexecute_constant :
  (context * context) ->
    ((identifier * bool * strength) * constr) -> constant_object

val infexecute_constant_red :
  (context * context) ->
    ((identifier * bool * strength) * constr) -> Reduction.red_expr option -> constant_object

val abstract_constant :
  identifier list -> constant_body -> constant_body * modification_action list
val expmod_constant :
  (sorts oper * sorts oper modification) list -> constant_body -> constant_body
val process_recipe_cmap :
  (section_path * section_path) ->
    (identifier list * (sorts oper * sorts oper modification) list) ->
      (path_kind * constant_body) list ->
        (sorts oper * sorts oper modification) list *
        (path_kind * constant_body) list

val infexecute_parameter :
 (context * context) -> identifier -> constr ->
    constant_object

val cooked_body : constant_body -> constr option;;

val cook_constant : section_path -> unit;;

val set_transparent_sp : section_path -> unit;;
val set_transparent : identifier -> unit;;
val set_transparent_extraction : identifier -> unit;;
val set_opaque_sp : section_path -> unit;;
val set_opaque : identifier -> unit;;

(* $Id: constants.mli,v 1.8 1999/11/01 12:41:11 mohring Exp $ *)
