(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                               command.mli                                *)
(****************************************************************************)
open Names;;
open Term;;

open Constrtypes;;

val definition_body : identifier -> strength -> CoqAst.t -> unit;;
val definition_body_red : identifier -> strength -> CoqAst.t 
  -> Reduction.red_expr option -> unit;;
val syntax_definition : identifier -> CoqAst.t -> unit;;
val abstraction_definition : identifier -> int array -> CoqAst.t -> unit;;
val hypothesis_def_var : bool -> string -> strength -> CoqAst.t -> unit;;
val parameter_def_var : string -> CoqAst.t -> unit;;

val build_mutual :  (identifier * CoqAst.t) list -> (identifier * CoqAst.t * (identifier * CoqAst.t) list) list -> bool -> unit;;

val build_recursive :  (identifier * ((identifier * CoqAst.t) list) * CoqAst.t * CoqAst.t) list -> unit;;
val build_corecursive :  (identifier * CoqAst.t * CoqAst.t) list -> unit;;


val mkProdCit : (identifier * CoqAst.t) list -> CoqAst.t -> CoqAst.t ;;
val build_scheme : (identifier * bool * CoqAst.t * CoqAst.t) list -> unit;;

(* $Id: command.mli,v 1.10 1999/07/08 17:13:38 mohring Exp $ *)
