(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                vartab.mli                                *)
(****************************************************************************)

(* Management of the table of local variables (variables declared by
   Variable or Hypothesis inside a section)
   Used also temporary for variable local to inductive defintions *)

open Names;;
open More_util;;
open Term;;
open Constrtypes;;

val initial_sign : unit -> context;;
val initial_fsign : unit -> context;;
val initial_assumptions : unit -> context * context;;

val auto_save_variables : unit -> identifier list;;
val stre_of_var : identifier -> strength;;
val implicits_of_var : Names.path_kind -> identifier -> int list;;

(* standard interface part for summaries *)
val push : identifier -> bool
  -> (type_judgement * (type_judgement*implicits_typ) option)
  -> strength -> implicits_typ -> unit;;
val init : unit -> unit;;
type frozen_t;;
val freeze : unit -> frozen_t;;
val unfreeze : frozen_t -> unit;;
val rollback : (unit -> unit) -> unit -> unit;;

(* $Id: vartab.mli,v 1.9 1999/08/06 20:49:07 herbelin Exp $ *)
