/*
 * Time-stamp: <99/02/19 08:47:12 panic>
 * Author:	The C-Mix Project <cmix@diku.dk>
 *         	Peter Holst Andersen <txix@diku.dk>
 *              Torben Mogensen <torbenm@diku.dk>
 *              Arne John Glenstrup  <panic@diku.dk>
 * Contents:	Functions for showing the image using SRGP
 *		(Simple Raster Graphics Package) from
 *              http://www.cs.brown.edu/software/catalog.html
 */

#include <stdio.h>
#include <stdlib.h>
#include <srgp/srgp.h>
#include "ray.h"

static int use_color;
static int number_of_colors;

void initWindow(char *title, int height, int width, int use_c)
{
    int i, j, m;
    unsigned short k, r, g, b;

    use_color = use_c;
    
    SRGP_begin(title, width, height, 8, FALSE);
    SRGP_refresh();
    i = SRGP_inquireCanvasDepth();
    if (use_color) {
	if (i != 8) {
	    fprintf(stderr, "Only supports 8 bitplanes in color mode\n");
	    exit(1);
        }
	for(m = 0; m < 216; m++) {
	    r = 13107*(m % 6);
	    g = 13107*((m/6)%6);
	    b = 13107*((m/36)%6);
	    SRGP_loadColorTable(m + 2, 1, &r, &g, &b);
	}
	for(m = 0; m < 27; m++) {
	    r = 3277*(m % 3);
	    g = 3277*((m/3)%3);
	    b = 3277*((m/9)%3);
	    SRGP_loadColorTable(m + 220, 1, &r, &g, &b);
	}
    }
    else {
	j = (1 << i);
	for(m = 0; m < j - 2; m++) {
	    k = 256*256*m/j;
	    SRGP_loadColorTable(m + 2, 1, &k, &k, &k);
	}
	number_of_colors = j;
    }
}

void closeWindow() { }

static void plot_color(int x, int y, myfloat red, myfloat green, myfloat blue)
{
    short r,g,b;
    static double r_err, g_err, b_err;

    r_err += red * 6.0;
    g_err += green * 6.0;
    b_err += blue * 6.0;

    if (r_err<1.0 && g_err<1.0 && b_err<1.0) {
	r = (short) (r_err * 3.0);
	if (r<0) r = 0;
	g = (short) (g_err * 3.0);
	if (g<0) g = 0;
	b = (short) (b_err * 3.0);
	if (b<0) b = 0;

	r_err -= (r/3.0);
	g_err -= (g/3.0);
	b_err -= (b/3.0);

	SRGP_setColor(r+3*g+9*b+220);

    }
    else {   
	r = (short) (r_err + 0.5);
	if (r>=6) r = 5;
	g = (short) (g_err + 0.5);
	if (g>=6) g = 5;
	b = (short) (b_err + 0.5);
	if (b>=6) b = 5;

	r_err -= r;
	g_err -= g;
	b_err -= b;

	SRGP_setColor(r+6*g+36*b+2);
    }
    SRGP_pointCoord(x, y);
}

static void plot_grey(int x, int y, myfloat red, myfloat green, myfloat blue)
{
    int i;
    
    i = (red * 0.299 + green * 0.587 + blue * 0.114) *
	number_of_colors + (RANDOM()%100000)/100000.0;

    if (i <= 0)
	i = SRGP_BLACK;
    else if (i >= number_of_colors - 1)
	i = SRGP_WHITE;
    else
	i++;

    SRGP_setColor(i);
    SRGP_pointCoord(x, y);
}

void plot(int x, int y, myfloat red, myfloat green, myfloat blue)
{
    if (use_color)
	plot_color(x, y, red, green, blue);
    else
	plot_grey(x, y, red, green, blue);
}

void refreshLine(int y) {
  SRGP_refresh();
}

int waitKeyOrClick() {
  locator_measure mouse;
  int quit = (0 != 0);
  SRGP_setKeyboardProcessingMode(RAW);
  SRGP_setInputMode(KEYBOARD, EVENT);
  SRGP_setInputMode(LOCATOR, EVENT);
  while (1) {
    int device = SRGP_waitEvent(-1);
    if (device == KEYBOARD) {
      char key[2];
      SRGP_getKeyboard(key, 2);
      return key[0];
    }
    if (device == LOCATOR) {
      SRGP_getLocator(&mouse);
      if (mouse.button_chord[LEFT_BUTTON] == UP &&
	  mouse.button_of_last_transition == LEFT_BUTTON)
	return -1;
    }
  }
}

