
########################################################################
## a local global value
set newMan {}		;# file handle of manual output file


########################################################################

proc o {s} {
  global newMan
  puts -nonewline $newMan $s
}
########################################################################
proc on {s} {
  global newMan
  puts $newMan $s
}
########################################################################
proc skipToEnd {inFile tag inName} {
  global Program newMan
  set rexp {\.\\\" +cligPart +}
  append rexp "$tag +end"
  while { -1<[gets $inFile line] } {
    if {[regexp $rexp $line]} return
  }
  puts stderr \
      "$Program: did not find end of `cligPart $tag' in file `$inName'"
  close $newMan
  exec rm -f $inName.[pid]
  exit 1
}
########################################################################
proc doManTITLE {} {
  global nameString versionString
  if { [info exist versionString] } {
    set v $versionString
  } else {
    set v [exec date +%Y-%m-%d]
  }
  o ".TH \"$nameString\" 1 \"$v\" "
  on "\"Clig-manuals\" \"Programmer's Manual\""
}
########################################################################
proc doManNAME {} {
  global nameString usageString

  on ".SH NAME"
  on "$nameString \\- $usageString"
}
########################################################################
proc doManSYNOPSIS {} {
  global D L nameString
  on ".SH SYNOPSIS"
  on ".B $nameString"

  #####
  ##### generate an entry for every option
  #####
  foreach opt $L {
    set optional [expr ![info exist D($opt,mandatory)]]
    set parOptional [expr {$D($opt,type)!="flag" && 0==$D($opt,cmin)}]

    if $optional {o "\["}
    o $opt
    
    if { $D($opt,type)!="flag" } {
      if {$parOptional} { 
	o " \[" 
      } else { 
	o " " 
      }
      o $D($opt,name)
      
      if {$parOptional} { o "\]" }
    }
    if {$optional} {o "\]"}
    on {}
  }
  #####
  ##### generate dots, if non-option parameters are allowed, i.e. Rest
  #####
  if { [info exist D(...,name)] } {
    if { $D(...,cmin)==0 } {o "\["}
    o "$D(...,name)"
    if { [Infty $D(...,cmax)] || $D(...,cmax)>1 }  {o " ..."}
    if { $D(...,cmin)==0 } {o "\]"}
  }
  on {}
}
########################################################################
proc doManOPTIONS {} {
  global D L

  on ".SH OPTIONS"

  ##### description of every parameter
  foreach opt $L {
    if { $D($opt,type)=="flag" } {
      on ".IP $opt\n$D($opt,usage)."
    } else {
      on ".IP $opt\n$D($opt,usage),"
      ##### count
      o ".br\n$D($opt,cmin)"
      if { [Infty $D($opt,cmax)] } {
	o " or more"
      } elseif { $D($opt,cmax)>$D($opt,cmin) } {
	o "...$D($opt,cmax)"
      }
      if { $D($opt,cmax)==1 && $D($opt,cmin)==1} {
	o " $D($opt,typename) value"
      } else {
	o " $D($opt,typename) values"
      }	

      ##### range
      if { [info exist D($opt,min)] && 
	   (![negInfty $D($opt,min)] || ![Infty $D($opt,max)]) } {
	o " between $D($opt,min) and $D($opt,max)"
      }
      o .
      ##### default:
      if { [info exist D($opt,default)] } {
	o "\n.br\nDefault:"
	foreach x $D($opt,default) {
	  o " `$x'"
	}
      }
      on {}
    }
  }

  #####
  ##### description of non-option arguments
  #####
  if { [info exist D(...,name)] } {
    on ".IP $D(...,name)"
    on $D(...,usage).
  }
}  
########################################################################
proc doManDESCRIPTION {} {
  global descriptionString

  on ".SH DESCRIPTION"
  if { [info exist descriptionString] } {
    on $descriptionString
  } else {
    on "This manual page was generated automagically by clig, the"
    on "Command Line Interface Generator. Actually the programmer"
    on "using clig was supposed to edit this part of the manual"
    on "page after"
    on "generating it with clig, but obviously (s)he didn't."
    on "\nSadly enough clig does not yet have the power to pick a good"
    on "program description out of blue air ;-("
  }
}
########################################################################
proc genMan {manFile} {
  global D L cbase Program
  global newMan

  ##### if the manual file does not exist, get a template file
  if {![file exist $manFile]} {
    exec cp [glob $cbase/template.man] $manFile
  }
  
  ##### open the input file
  set oldMan [open $manFile r]

  ##### open a temporary file
  #puts " opening $manFile.[pid]"
  set newMan [open $manFile.[pid] w]

  #####
  ##### copy the original file into the new manual file, while replacing
  ##### marked sections with new information
  #####
  set hadOneSection 0
  while { -1<[gets $oldMan line] } {
    if { [llength $line]==3 && "cligPart"==[lindex $line 1] } {
      set hadOneSection 1
      set section [lindex $line 2]
      skipToEnd $oldMan $section $manFile
      on ".\\\" cligPart $section"
      doMan$section
      on ".\\\" cligPart $section end"
    } else {
      on $line
    }
  }

  close $oldMan
  close $newMan
  exec mv -f $manFile.[pid] $manFile

  #####
  ##### Warning, if the man-page had nothing to edit
  #####
  if { ! $hadOneSection } {
    puts stderr \
	"*** $Program: nothing to edit in `$manFile'"
  }
}
