use Language::INTERCAL;
use Language::INTERCAL::Runtime::Library;

my $prog = '
@@@@@@@@K@L`@{
@@@@@@@@@@@
@@@@@@@@@@@@@@
@@@@@@@@@@@@@
@@@@@@@@K@L`@{@@@@K
@@@@@@@@@{@@M]@@@|
@@@@@@@@@K@@@{
@@@@@@@@K@L`@{
@@@@@@@@@@@@@@@
@@@@@@@@K@@{@@@@K
@@@@@@@@@
M]@@[|@L`@{
@@@@@@@@[|@L`@{
@@@@@@@@@
';

print "1..36\n";

fiddle Language::INTERCAL 'bug=0', 'ubug=0';

my @foo;

compile Language::INTERCAL 'prog', $prog;
@foo= ();
eval { prog(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 1\n";
print @foo == 7 ? "" : "not ", "ok 2\n";
print "I\n" eq (shift @foo) ? "" : "not ", "ok 3\n";
print "I\n" eq (shift @foo) ? "" : "not ", "ok 4\n";
print "IX\n" eq (shift @foo) ? "" : "not ", "ok 5\n";
print "IX\n" eq (shift @foo) ? "" : "not ", "ok 6\n";
print "III\n" eq (shift @foo) ? "" : "not ", "ok 7\n";
print "IV\n" eq (shift @foo) ? "" : "not ", "ok 8\n";
print "IV\n" eq (shift @foo) ? "" : "not ", "ok 9\n";

compile Language::INTERCAL 'prog_o', $prog, 'opt';
@foo= ();
eval { prog_o(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 10\n";
print @foo == 7 ? "" : "not ", "ok 11\n";
print "I\n" eq (shift @foo) ? "" : "not ", "ok 12\n";
print "I\n" eq (shift @foo) ? "" : "not ", "ok 13\n";
print "IX\n" eq (shift @foo) ? "" : "not ", "ok 14\n";
print "IX\n" eq (shift @foo) ? "" : "not ", "ok 15\n";
print "III\n" eq (shift @foo) ? "" : "not ", "ok 16\n";
print "IV\n" eq (shift @foo) ? "" : "not ", "ok 17\n";
print "IV\n" eq (shift @foo) ? "" : "not ", "ok 18\n";

compile Language::INTERCAL 'prog_p', $prog, 'post';
@foo= ();
eval { prog_p(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 19\n";
print @foo == 7 ? "" : "not ", "ok 20\n";
print "I\n" eq (shift @foo) ? "" : "not ", "ok 21\n";
print "I\n" eq (shift @foo) ? "" : "not ", "ok 22\n";
print "IX\n" eq (shift @foo) ? "" : "not ", "ok 23\n";
print "IX\n" eq (shift @foo) ? "" : "not ", "ok 24\n";
print "III\n" eq (shift @foo) ? "" : "not ", "ok 25\n";
print "IV\n" eq (shift @foo) ? "" : "not ", "ok 26\n";
print "IV\n" eq (shift @foo) ? "" : "not ", "ok 27\n";

compile Language::INTERCAL 'prog_d', $prog, 'dbhook';
@foo= ();
_run_db(prog_d(0, \&foo));
print STDERR $@;
print $@ ? "not " : "", "ok 28\n";
print @foo == 7 ? "" : "not ", "ok 29\n";
print "I\n" eq (shift @foo) ? "" : "not ", "ok 30\n";
print "I\n" eq (shift @foo) ? "" : "not ", "ok 31\n";
print "IX\n" eq (shift @foo) ? "" : "not ", "ok 32\n";
print "IX\n" eq (shift @foo) ? "" : "not ", "ok 33\n";
print "III\n" eq (shift @foo) ? "" : "not ", "ok 34\n";
print "IV\n" eq (shift @foo) ? "" : "not ", "ok 35\n";
print "IV\n" eq (shift @foo) ? "" : "not ", "ok 36\n";

sub foo {
    push @foo, join('', @_);
}

