(* camlp4r *)
(***********************************************************************)
(*                                                                     *)
(*                             Camlp4                                  *)
(*                                                                     *)
(*        Daniel de Rauglaudre, projet Cristal, INRIA Rocquencourt     *)
(*                                                                     *)
(*  Copyright 1998 Institut National de Recherche en Informatique et   *)
(*  Automatique.  Distributed only by permission.                      *)
(*                                                                     *)
(***********************************************************************)

(* $Id: apply.ml,v 2.1 1999/03/03 23:49:36 ddr Exp $ *)

value tb1 = "(* camlp4r";
value tb2 = "(* camlp4";
value te = " *)";

value eq_substr s1 i s2 =
  loop i 0 where rec loop i j =
    if j = String.length s2 then True
    else if i = String.length s1 then False
    else if s1.[i] == s2.[j] then loop (i + 1) (j + 1)
    else False
;

value launch s =
  do Printf.eprintf "%s\n" s;
     flush stderr;
  return
  let r = Sys.command s in
  if r <> 0 then exit 2 else ()
;

value go () =
  let file = ref "" in
  let args = ref "" in
  do for i = 1 to Array.length Sys.argv - 1 do
       if i == Array.length Sys.argv - 1 then file.val := Sys.argv.(i)
       else args.val := args.val ^ Sys.argv.(i) ^ " ";
     done;
  return
  if file.val = "" then ()
  else
    match try Some (open_in file.val) with _ -> None with
    [ Some ic ->
        let line = input_line ic in
        let r =
          if eq_substr line 0 tb1
          && eq_substr line (String.length line - String.length te) te then
            "camlp4r" ^
            String.sub line (String.length tb1)
              (String.length line - String.length tb1 - String.length te)
          else if eq_substr line 0 tb2
          && eq_substr line (String.length line - String.length te) te then
            "camlp4" ^
            String.sub line (String.length tb2)
              (String.length line - String.length tb2 - String.length te)
          else "camlp4o"
        in
        do close_in ic;
           launch (r ^ " " ^ args.val ^ file.val);
        return ()
    | None -> () ]
;

Printexc.catch go ();
