(* camlp4r *)
(***********************************************************************)
(*                                                                     *)
(*                             Camlp4                                  *)
(*                                                                     *)
(*        Daniel de Rauglaudre, projet Cristal, INRIA Rocquencourt     *)
(*                                                                     *)
(*  Copyright 1998 Institut National de Recherche en Informatique et   *)
(*  Automatique.  Distributed only by permission.                      *)
(*                                                                     *)
(***********************************************************************)

(* $Id: pretty.mli,v 2.0 1998/12/01 08:19:41 ddr Exp $ *)

type glue = [ LO | RO | LR | NO ];
type pretty =
  [ S of glue and string
  | Hbox of Stream.t pretty
  | HVbox of Stream.t pretty
  | HOVbox of Stream.t pretty
  | HOVCbox of Stream.t pretty
  | Vbox of Stream.t pretty
  | BEbox of Stream.t pretty
  | BEVbox of Stream.t pretty ]
;

value print_pretty : out_channel -> string -> int -> pretty -> unit;
value quiet : ref bool;

(*--*)

value dt : ref int;
value tol : ref int;
value sp : ref char;

type pr_fun =
  (MLast.expr -> string -> Stream.t pretty -> pretty) ->
  (MLast.patt -> string -> Stream.t pretty -> pretty) ->
  MLast.expr -> string -> Stream.t pretty -> pretty
;
value has_pr_fun : string -> bool;
value pr_fun : string -> pr_fun;
value add_pr_fun : string -> pr_fun -> unit;
