(* camlp4r *)
(***********************************************************************)
(*                                                                     *)
(*                             Camlp4                                  *)
(*                                                                     *)
(*        Daniel de Rauglaudre, projet Cristal, INRIA Rocquencourt     *)
(*                                                                     *)
(*  Copyright 1998 Institut National de Recherche en Informatique et   *)
(*  Automatique.  Distributed only by permission.                      *)
(*                                                                     *)
(***********************************************************************)

(* $Id: mLast.mli,v 2.4 1999/06/24 12:54:16 ddr Exp $ *)

(* Module [MLast]: abstract syntax tree *)

type loc = (int * int);

type ctyp =
  [ TyAcc of loc and ctyp and ctyp
  | TyAli of loc and ctyp and ctyp
  | TyAny of loc
  | TyApp of loc and ctyp and ctyp
  | TyArr of loc and ctyp and ctyp
  | TyCls of loc and list string
  | TyLid of loc and string
  | TyMan of loc and ctyp and ctyp
  | TyObj of loc and list (string * ctyp) and bool
  | TyQuo of loc and string
  | TyRec of loc and list (string * bool * ctyp)
  | TySum of loc and list (string * list ctyp)
  | TyTup of loc and list ctyp
  | TyUid of loc and string
  | TyXnd of loc and string and ctyp ]
;

type patt =
  [ PaAcc of loc and patt and patt
  | PaAli of loc and patt and patt
  | PaAnt of loc and patt
  | PaAny of loc
  | PaApp of loc and patt and patt
  | PaArr of loc and list patt
  | PaChr of loc and char
  | PaInt of loc and string
  | PaLid of loc and string
  | PaOrp of loc and patt and patt
  | PaRng of loc and patt and patt
  | PaRec of loc and list (patt * patt)
  | PaStr of loc and string
  | PaTup of loc and list patt
  | PaTyc of loc and patt and ctyp
  | PaUid of loc and string
  | PaXnd of loc and string and patt ]
;

type class_infos 'a =
  { ciLoc : loc;
    ciVir : bool;
    ciPrm : (loc * list string);
    ciNam : string;
    ciExp : 'a }
;

type expr =
  [ ExAcc of loc and expr and expr
  | ExAnt of loc and expr
  | ExApp of loc and expr and expr
  | ExAre of loc and expr and expr
  | ExArr of loc and list expr
  | ExAss of loc and expr and expr
  | ExChr of loc and char
  | ExCoe of loc and expr and ctyp
  | ExFlo of loc and string
  | ExFor of loc and string and expr and expr and bool and list expr
  | ExFun of loc and list (patt * option expr * expr)
  | ExIfe of loc and expr and expr and expr
  | ExInt of loc and string
  | ExLet of loc and bool and list (patt * expr) and expr
  | ExLid of loc and string
  | ExLmd of loc and string and module_expr and expr
  | ExMat of loc and expr and list (patt * option expr * expr)
  | ExNew of loc and list string
  | ExOvr of loc and list (string * expr)
  | ExRec of loc and list (expr * expr) and option expr
  | ExSeq of loc and list expr and expr
  | ExSnd of loc and expr and string
  | ExSte of loc and expr and expr
  | ExStr of loc and string
  | ExTry of loc and expr and list (patt * option expr * expr)
  | ExTup of loc and list expr
  | ExTyc of loc and expr and ctyp
  | ExUid of loc and string
  | ExWhi of loc and expr and list expr
  | ExXnd of loc and string and expr ]
and module_type =
  [ MtAcc of loc and module_type and module_type
  | MtApp of loc and module_type and module_type
  | MtFun of loc and string and module_type and module_type
  | MtLid of loc and string
  | MtSig of loc and list sig_item
  | MtUid of loc and string
  | MtWit of loc and module_type and list with_constr ]
and sig_item =
  [ SgCls of loc and list (class_infos class_type)
  | SgClt of loc and list (class_infos class_type)
  | SgDcl of loc and list sig_item
  | SgExc of loc and string and list ctyp
  | SgExt of loc and string and ctyp and list string
  | SgInc of loc and module_type
  | SgMod of loc and string and module_type
  | SgMty of loc and string and module_type
  | SgOpn of loc and list string
  | SgTyp of loc and list (string * list string * ctyp * list (ctyp * ctyp))
  | SgVal of loc and string and ctyp ]
and with_constr =
  [ WcTyp of loc and list string and list string and ctyp
  | WcMod of loc and list string and module_type ]
and module_expr =
  [ MeAcc of loc and module_expr and module_expr
  | MeApp of loc and module_expr and module_expr
  | MeFun of loc and string and module_type and module_expr
  | MeStr of loc and list str_item
  | MeTyc of loc and module_expr and module_type
  | MeUid of loc and string ]
and str_item =
  [ StCls of loc and list (class_infos class_expr)
  | StClt of loc and list (class_infos class_type)
  | StDcl of loc and list str_item
  | StExc of loc and string and list ctyp
  | StExp of loc and expr
  | StExt of loc and string and ctyp and list string
  | StMod of loc and string and module_expr
  | StMty of loc and string and module_type
  | StOpn of loc and list string
  | StTyp of loc and list (string * list string * ctyp * list (ctyp * ctyp))
  | StVal of loc and bool and list (patt * expr) ]
and class_type =
  [ CtCon of loc and list string and list ctyp
  | CtFun of loc and ctyp and class_type
  | CtSig of loc and option ctyp and list class_sig_item
  | CtXnd of loc and string and class_type ]
and class_sig_item =
  [ CgCtr of loc and ctyp and ctyp
  | CgInh of loc and class_type
  | CgMth of loc and string and bool and ctyp
  | CgVal of loc and string and bool and ctyp
  | CgVir of loc and string and bool and ctyp ]
and class_expr =
  [ CeApp of loc and class_expr and list expr
  | CeCon of loc and list string and list ctyp
  | CeFun of loc and patt and class_expr
  | CeLet of loc and bool and list (patt * expr) and class_expr
  | CeStr of loc and option patt and list class_str_item
  | CeTyc of loc and class_expr and class_type
  | CeXnd of loc and string and class_expr ]
and class_str_item =
  [ CrCtr of loc and ctyp and ctyp
  | CrInh of loc and class_expr and option string
  | CrIni of loc and expr
  | CrMth of loc and string and bool and expr
  | CrVal of loc and string and bool and expr
  | CrVir of loc and string and bool and ctyp ]
;

type directive_param =
  [ DpNon | DpStr of string | DpInt of string | DpIde of list string ]
;

type phrase =
  [ PhStr of loc and str_item | PhDir of loc and string and directive_param ]
;

external loc_of_ctyp : ctyp -> loc = "%field0";
external loc_of_patt : patt -> loc = "%field0";
external loc_of_expr : expr -> loc = "%field0";
external loc_of_module_type : module_type -> loc = "%field0";
external loc_of_module_expr : module_expr -> loc = "%field0";
external loc_of_sig_item : sig_item -> loc = "%field0";
external loc_of_str_item : str_item -> loc = "%field0";
external loc_of_phrase : phrase -> loc = "%field0";
