------------------------------------------------------------------------------
--                                                                          --
--             ASIS Tester And iNTerpreter (ASIStant) COMPONENTS            --
--                                                                          --
--                        A S I S T A N T . H E L P                         --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--          Copyright (c) 1997-1999, Free Software Foundation, Inc.         --
--                                                                          --
-- ASIStant is free software; you can redistribute it and/or modify it      --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version. ASIStant is distributed  in the hope  that it will be useful,   --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of MER-      --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General  --
-- Public License for more details. You should have received a copy of the  --
-- GNU General Public License distributed with GNAT; see file COPYING. If   --
-- not, write to the Free Software Foundation, 59 Temple Place Suite 330,   --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
-- ASIStant is an evolution of ASIStint tool that was created by            --
-- Vasiliy Fofanov as part of a collaboration between Software Engineering  --
-- Laboratory of the Swiss Federal Institute of Technology in Lausanne,     --
-- Switzerland, and the Scientific Research Computer Center of the Moscow   --
-- University, Russia, supported by the Swiss National Science Foundation   --
-- grant #7SUPJ048247, "Development of ASIS for GNAT with industry quality" --
--                                                                          --
-- ASIStant is distributed as a part of the ASIS implementation for GNAT    --
-- (ASIS-for-GNAT) and is maintained by Ada Core Technologies Inc           --
-- (http ://www.gnat.com).                                                   --
------------------------------------------------------------------------------

with Asis;                       use Asis;

with Asis.Implementation;

with ASIStant.Ambiguous_Mapping; use ASIStant.Ambiguous_Mapping;
with ASIStant.Call;              use ASIStant.Call;
with ASIStant.Common;            use ASIStant.Common;
with ASIStant.S_Parser;          use ASIStant.S_Parser;
with ASIStant.Table;             use ASIStant.Table;
with ASIStant.String_Handling;   use ASIStant.String_Handling;
with ASIStant.Text_IO;           use ASIStant.Text_IO;

with ASIStant.FuncEnum;          use ASIStant.FuncEnum;

package body ASIStant.Help is

   procedure Display_Syntax (SW : Switch_Index; SYNT : Func_Syntax);
   --  ??? Should get documented

------------------------------------------------------------------------------
--  ASIStant Help System
------------------------------------------------------------------------------

   procedure Display_Syntax (SW : Switch_Index; SYNT : Func_Syntax) is
   --  Local subprogram:
   --  Displays the text representation of a given syntax structure
   begin
      ATIPut ("   ");
      ATIPut (Switch_Index'Wide_Image (SW));

      if SYNT (1) /= Par_Absent then
         ATIPut (" (");
      end if;

      for i in Parameter_Range loop
         exit when SYNT (i) = Par_Absent;
         if i /= 1 then
            ATIPut (", ");
         end if;

         ATIPut (Skip_Prefix (Func_Param'Wide_Image (SYNT (i))));
      end loop;

      if SYNT (1) /= Par_Absent then
         ATIPut (")");
      end if;

      if SYNT (0) /= Par_Absent then
         ATIPut (" return ");
         ATIPut (Skip_Prefix (Func_Param'Wide_Image (SYNT (0))));
      end if;

      ATINew_Line;
   end Display_Syntax;


   procedure ASISHelp is
   --  ASIS and ASIStant tech info

   begin
      Print_ASIStant_Header;
      ATINew_Line;
      ATIPut_Line ("ASIS and ASIStant Technical and Copyright Information :");
      ATINew_Line;
      ATIPut ("  Asis Version :              ");
      ATIPut_Line (Asis.Implementation.ASIS_Version);
      ATIPut ("  Asis Implementor Version :  ");
      ATIPut_Line (Asis.Implementation.ASIS_Implementor_Version);
      ATIPut ("  Asis Implementor :          ");
      ATIPut_Line (Asis.Implementation.ASIS_Implementor);
      ATIPut ("  Asis Implementor Info :     ");
      ATIPut_Line (Asis.Implementation.ASIS_Implementor_Information);
      ATINew_Line;
      ATIPut_Line ("  ASIStant author Info :      "
                 & "Vasiliy Fofanov, ASIS-for-GNAT team at ACT Inc.");
      ATIPut_Line (
         "                              Email : fofanov@act-europe.fr");
      ATIPut_Line ("  ASIStant status :");

      if Log then
         ATIPut_Line ("          Log enabled. Output Level : "
                      & Integer'Wide_Image (OutputLevel));
      else
         ATIPut_Line ("          Log disabled.");
      end if;

      if Script > 0 then
         ATIPut_Line ("          Script enabled (level " &
                      Integer'Wide_Image (Script) & ") and is in " &
                      Script_Mode'Wide_Image (ScriptMode) & " mode.");
      else
         ATIPut_Line ("          Script disabled.");
      end if;
   end ASISHelp;


   procedure Help (NP : Node_Position) is
      --  Help system

      T :  Func_Syntax;
      sw : Switch_Index;
      Amb : Amb_Index;
      N :  Node := CurStat.Tree (NP);

   begin

      ATINew_Line;

      if N.NValue = 0 then
         Print_ASIStant_Header;
         --  General help
         ATINew_Line;
         ATIPut_Line ("List of ASIStant utilities :");
         ATINew_Line;
         ATIPut_Line ("  HELP (<query-name>)    "
                      & " Displays a syntax of an ASIS query <query-name>");
         ATIPut_Line ("  IF (<bool-expr>,<expr1>[,<expr2>]) Executes <expr1> "
                      & "if <bool-expr> is true,");
         ATIPut_Line ("                                     otherwise, "
                      & "executes <expr2> if present");
         ATIPut_Line ("  INFO                    Displays ASIS and ASIStant "
                      & "technical info");
         ATIPut_Line ("  LOG [(""<filename>"")]    Opens file as a current "
                      & "log/closes current log");
         ATIPut_Line ("  LOGLEVEL (<level>)      Sets a logging level to "
                      & "integer <level>, 0..5");
         ATIPut_Line ("  PAUSE                   Pauses current script");
         ATIPut_Line ("  PRINT (<variable>)      Prints a value "
                      & "of a variable");
         ATIPut_Line ("  PRINTDETAIL (""{D|d}{T|t}"") Changes PRINT settings");
         ATIPut_Line ("  QUIT [(<exit-status>)]  Exits program returning "
                      & "<exit-status> or 0");
         ATIPut_Line ("  RUN [(""<filename>"")]    Launches script "
                      & "<filename>/resumes paused script");
         ATIPut_Line ("                          (IRUN = interactively)");
         ATIPut_Line ("  SET ( <ID>, <expr> )    Declares or changes "
                      & "variable <ID>");
         ATINew_Line;

         ATIPut_Line ("Please refer to ASIStant User's Guide for more "
                      & "information.");
      else
         --  ASIS queries help
         N := CurStat.Tree (N.NValue);
         --  receive parameter list
         N := CurStat.Tree (N.NValue);
         --  receive first element
         sw := Switch_Index'Wide_Value (N.SValue.all);

         for i in Switch_Info'Range loop

            if sw in Switch_Info (i).From .. Switch_Info (i).To then
               T := Switch_Info (i).Synt;
               exit;
            end if;

         end loop;

         ATIPut_Line ("Syntax help for the query " &
                      Switch_Index'Wide_Image (sw) & ":");

         begin
            Amb := Amb_Index'Value (Switch_Index'Image (sw));

            for i in 1 .. AI_LENGTH loop
               exit when Amb_Info (Amb, i).New_Index = Invalid_Index;
               Display_Syntax (sw, Amb_Info (Amb, i).Synt);
            end loop;

         exception
            when CONSTRAINT_ERROR => Display_Syntax (sw, T);
         end;

      end if;
   exception
      when CONSTRAINT_ERROR =>
         Error (ERR_UNKNOWNQUERY, N.SValue.all);
   end Help;

end ASIStant.Help;