#pragma interface
#ifndef DATETIME_H
#define DATETIME_H

#include <stdio.h>

#ifndef MISC_H
	#include <misc.h>
#endif

#ifndef DAEMONI_H
	#include "daemoni.h"
#endif

class NETCONF_HELP_FILE: public HELP_FILE{
	/*~PROTOBEG~ NETCONF_HELP_FILE */
public:
	NETCONF_HELP_FILE (const char *fname);
	/*~PROTOEND~ NETCONF_HELP_FILE */
};

class DATETIME{
	char universal;
	char alphaarc;
	SSTRING netdate;
	/*~PROTOBEG~ DATETIME */
public:
	DATETIME (void);
	int edit (void);
	int getfromcmos (void);
	int getfromnet (void);
	void save (void);
	void updatecmos (void);
	/*~PROTOEND~ DATETIME */
};

class ROUTED{
	char required;
	char silent;
	char gateway;
	/*~PROTOBEG~ ROUTED */
public:
	ROUTED (void);
	int edit (void);
	int is_required (void);
	void save (void);
	void setoptions (char *buf);
	/*~PROTOEND~ ROUTED */
};

class IP_ALIAS: public ARRAY_OBJ{
public:
	int num;		// no of the alias
	SSTRING ip;		// Ip number
	SSTRING mask;	// Optional netmask (default to 255.255.255.255)
	/*~PROTOBEG~ IP_ALIAS */
public:
	IP_ALIAS (const char *_ip, const char *_mask);
	IP_ALIAS (int _num,
		 const char *_ip,
		 const char *_mask);
private:
	void init (int _num,
		 const char *_ip,
		 const char *_mask);
public:
	int set (int _num, const char *devname);
	int unset (const char *devname);
	/*~PROTOEND~ IP_ALIAS */
};

class IP_ALIASES: public ARRAY{
	/*~PROTOBEG~ IP_ALIASES */
public:
	IP_ALIAS *getitem (const char *ip,
		 const char *mask);
	IP_ALIAS *getitem (int no);
	int getmaxnum (void);
	void readproc (const char *devname);
	int setnew (const char *,
		 const char *ips,
		 const char *mask,
		 char *err);
	int setup (const char *devname);
	int unsetall (const char *devname);
	/*~PROTOEND~ IP_ALIASES */
};


class SERVICE;
class SERVICES;

#define MAXSYSV_PROCESS	10		// 10 process manageable by a sysv script
								// manageable by linuxconf in fact

struct RCSYSV_CMD{
	SSTRING start;	// Start command
	COMMAND cstart;
	SSTRING stop;	// Stop command
	COMMAND cstop;
	SSTRING reload;	// Reload command
	COMMAND creload;
	SSTRING boot;	// Command at boot time executed once
	COMMAND cboot;
	SSTRING probe;	// Command used to decide if the package
					// must be restarted or not
					// The same command will be called with its
					// own output to make the restart effective
	COMMAND cprocess[MAXSYSV_PROCESS];
};

class CONFIG_SYSV: public ARRAY_OBJ{
public:
	SSTRING path;
	char autoreload;
	/*~PROTOBEG~ CONFIG_SYSV */
public:
	CONFIG_SYSV (const char *str, int _autoreload);
	/*~PROTOEND~ CONFIG_SYSV */
};
class CONFIG_SYSVS: public ARRAY{
	/*~PROTOBEG~ CONFIG_SYSVS */
public:
	CONFIG_SYSV *getitem (int no)const;
	void remove_empty (void);
	/*~PROTOEND~ CONFIG_SYSVS */
};

class DROPIN_SUBSYSS{
public:
	class LINUXCONF_SUBSYS **tb;
	int nbtb;
	/*~PROTOBEG~ DROPIN_SUBSYSS */
public:
	DROPIN_SUBSYSS (void);
	void alloc (int n);
	/*~PROTOEND~ DROPIN_SUBSYSS */
};

class RCSYSV: public DAEMON{
public:
	SSTRING desc;		// One line description of the dropin/sysv init script
	SSTRINGS processes;	// Names of the processes to monitor
	CONFIG_SYSVS monitors;	// Files to monitors to do a restart
	SSTRINGS pidfiles;	// path of the file containing the PID of the
	CONFIG_FILE *tbcfgpid[MAXSYSV_PROCESS];// main daemon.
	int nbcfgpid;
	char no_reload;		// This server is smart (Samba for one)
						// and there is no need to reload
	bool override;
	RCSYSV_CMD cmd;
	/*~PROTOBEG~ RCSYSV */
public:
	RCSYSV (void);
	void addmonitor (const char *line);
	int boot (void);
protected:
	void deletepids (void);
public:
	virtual int edit (const SERVICES&);
protected:
	int exec (COMMAND&c);
public:
	PROC *findprocess (bool&problem);
protected:
	virtual int getstaterun (void);
public:
	void init_command (void);
	void list_config (DROPIN_SUBSYSS&subs);
	int restart (void);
	int start (void);
	int startif (void);
	int stop (void);
	~RCSYSV (void);
	/*~PROTOEND~ RCSYSV */
};

class BOOTRC: public ARRAY_OBJ{
public:
	bool start_cmd;		// This is a "S" script to start something
						// as opposed to an "K" script
	bool was_processed;
	SSTRING path;		// absolute path of the script
	SSTRING name;		// name without the SXX prefix
	SSTRING equiv;		// Equivalent to a builtin service
	struct{
		int in,out,err;		// stdin,out,err used to start the init script
		long date;			// time at which the command was activated
	}pipes;
	RCSYSV ctrl;	// Is this an enhanced sysv script
					// with special control comments
					// If this is so, then ctrl knows how to
					// handle this package
	SSTRING description;
	/*~PROTOBEG~ BOOTRC */
public:
	BOOTRC (bool start_cmd,
		 const char *path,
		 const char *name,
		 const char *equiv);
	BOOTRC (const char *name, const char *equiv);
private:
	void init (const char *name, const char *equiv);
public:
	bool isenhanced (void);
private:
	void parseenh (char *line);
	void parseintro (FILE *fin);
public:
	int run (bool probe);
	void stop (void);
	/*~PROTOEND~ BOOTRC */
};

class BOOTRCS: public ARRAY{
	bool probe;			// Are we probing the sysv to find out if a
						// restart,stop,start is needed
						// or we are doing switching to a new runlevel
						// and sysv script must be executed
	int lastsysv;		// Start of the last section of sysv init script
						// after the last linuxconf's service.
	/*~PROTOBEG~ BOOTRCS */
public:
	BOOTRCS (bool _probe);
	void dostopcmds (void);
	BOOTRC *getitem (bool start_cmd, const char *name);
	BOOTRC *getitem (const char *name);
	BOOTRC *getitem (int no);
	void readall (const char *dirpath);
	void readdir (const char *dirpath,
		 const char *prevpath);
private:
	void readequiv (void);
public:
	void startrest (void);
	int startsome (const char *from);
	/*~PROTOEND~ BOOTRCS */
};

#endif
