/*
	This small utility is used to collect statistics about how many
	processes are running
*/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

int main (int, char *[])
{
	int ret = -1;
	FILE *fin = fopen ("/proc/loadavg","r");
	if (fin != NULL){
		char buf[100];
		if (fgets (buf,sizeof(buf)-1,fin)!=NULL){
			char *pt = strchr(buf,'/');
			if (pt != NULL){
				int nb = atoi(pt+1);
				int nbuser = 0;
				printf ("%d\n%d\n\nRunning processes and user processes\n"
					,nb,nbuser);
				ret = 0;
			}
		}
		fclose (fin);
	}
	if (ret == -1){
		printf ("0\n0\n\nCan't read /proc/loadavg\n");
	}
	return 0;
}



