/* ***********

	Check comments starting with // ### and fill appropriate code there

   ***********
*/
#pragma implementation
#include <stdio.h>
#include <string.h>
#include <translat.h>
#include <netconf.h>
#include <userconf.h>
#include "debian.h"
#include "debian.m"

MODULE_DEFINE_VERSION(debian);

PUBLIC MODULE_debian::MODULE_debian()
	: LINUXCONF_MODULE("debian")
{
	linuxconf_loadmsg ("debian", PACKAGE_REV);

	// This install an override (a filter in fact) for /etc/conf.linuxconf
	// management. Mostly, it allows the filter to intercept some updates
	// and direct the information in the proper Debian config files
	linuxconf_sethook (filter_fctnew);

	// This installs a hook to manage the "basic host information"
	// and "IPX configuration" data.
	// hostinfo_sethook (devinfo_load, devinfo_save);

	// This installs a hook to manage the routing
	// groutes_sethook (routes_load, routes_save);

	// This installs a hook to manage IP aliases
	// ipalias_sethook (devinfo_ipalias_load, devinfo_ipalias_save);

	// This installs a hook for password managemant using PAM
	#ifdef HAS_PAM
		// This installs a hook to manage user accounts
		// Linuxconf does not work well if the passwd hook are not
		// and the users hook are installed
		users_sethook (user_del, user_add, user_change);
		passwd_sethook (pam_check_pass, pam_change_pass, pam_check_pair);
	#endif
}


static const char *keymenu=NULL;

PUBLIC void MODULE_debian::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
#if 0
	if (context == MENU_MAIN_CONFIG){
		keymenu = MSG_U(M_debian,"Debian specific configuration");
		dia.new_menuitem ("debian","",keymenu);
	}
#endif
}

PUBLIC int MODULE_debian::domenu (
	MENU_CONTEXT context,
	const char *key)
{
#if 0
	if (context == MENU_MAIN_CONFIG){
		if (key == keymenu){
			debian_menu();
		}
	}
#endif
	return 0;
}

PUBLIC int MODULE_debian::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(key,"debian")==0){
		// ### Insert any menu and dialog here
		ret = 0;
	}
	return ret;
}


static void usage()
{
	xconf_error (MSG_U(T_USAGE
		,"module debian\n"
		 "\n"
		 "    --help\n")
		);
}


PUBLIC void MODULE_debian::usage (SSTRINGS &tb)
{
	tb.add (new SSTRING (MSG_R(T_USAGE)));
}


PUBLIC int MODULE_debian::execmain (int argc , char *argv[])
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"debian")==0) {
		ret = -1;
		if (argc == 1) {
#if 0
			debian_menu();
			ret = 0;
#endif
		} else if (argc == 2 && strcmp(argv[1],"--help")==0) {
			::usage();
		} else {
			::usage();
		}
	}
	return ret;
}


static MODULE_debian debian;
