#pragma implementation
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "virtdb.h"

/* #Specification: VIRTDB / strategy
	Linuxconf has a command line interface allowing one to easily
	manage different configuration file using a uniform command line
	interface.

	Linuxconf is virtualising access to several different config file
	using the VIRTDB objects. Each configuration file must register
	a static object derived from VIRTDB. This object must provide a name
	(normally the name of the configuration file. This object must
	also redefined the docmd function. The VIRTDB dispatcher do a small
	parsing of the command and then call the docmd of the proper
	object. This object read the configuration file and update the
	proper elements in it and then save the file.

	This should kill for good all those install scripts which try to
	sed/awk/perl there way in the different config files.
*/

static VIRTDB *first = NULL;

PUBLIC VIRTDB::VIRTDB (const char *_name)
{
	name = strdup(_name);
	next = first;
	first = this;
}

PUBLIC VIRTUAL VIRTDB::~VIRTDB ()
{
	VIRTDB **pt = &first;
	while (*pt != NULL){
		if (*pt == this){
			*pt = next;
			break;
		}
		pt = &(*pt)->next;
	}
	free (name);
}

static void usage()
{
	fprintf (stderr,
		"linuxconf --vdb config_file command options\n"
		"\n"
		"command may be one of:\n"
		"\tadd\n"
		"\tdelete\n"
		"\tget\n"
		"\treplace\n"
		"\n"
		"The following configuration files are supported:\n"
		);
	VIRTDB *pt = first;
	while (pt != NULL){
		fprintf (stderr,"\t%s\n",pt->name);
		pt = pt->next;
	}
}

int virtdb_main (int argc, char *argv[])
{
	int ret = -1;
	if (argc <= 1){
		usage();
	}else{
		const char *name = argv[0];
		const char *cmd = argv[1];
		argc -= 2;
		argv += 2;
		VIRTDB *pt = first;
		while (pt != NULL){
			if (strcmp(pt->name,name)==0){
				break;
			}
			pt = pt->next;
		}
		if (pt == NULL){
			usage();
		}else{
			if (strcmp(cmd,"delete")==0){
				ret = pt->docmd (VIRTDB_DELETE,argc,argv);
			}else if (strcmp(cmd,"add")==0){
				ret = pt->docmd (VIRTDB_ADD,argc,argv);
			}else if (strcmp(cmd,"replace")==0){
				ret = pt->docmd (VIRTDB_REPLACE,argc,argv);
			}else if (strcmp(cmd,"get")==0){
				ret = pt->docmd (VIRTDB_GETALL,argc,argv);
			}else{
				usage();
			}
		}
	}
	return ret;
}

