import java.awt.*;
/*
	Dispose les champs et tablie la dimension du Window
*/
class group extends mform{
	String title;
	public group(mform _parent, String _id, String _title){
		super (_parent, _id);
		int len = _title.length();
		marge_droite = marge_gauche = 10;
		marge_haut = marge_bas = 14;
		if (len == 0){
			title = null;
		}else{
			title = _title;
			min_width = len*14;
			marge_haut = 16;
		}
	}
	public group (mform _parent, String _id){
		super (_parent, _id);
		title = null;
		marge_droite = marge_gauche = 14;
		marge_haut = marge_bas = 14;
		min_width = 14;
	}

	/*
		Dessine le contour d'un groupe.
	*/

	void drawgroup(Graphics g){
		Color defcol = g.getColor();
		Color black  = Color.black;
		Color dark   = Color.darkGray;
		Color light  = Color.white;
		g.setFont(new Font("Helvetica", Font.PLAIN, 14));

		FontMetrics met = g.getFontMetrics();
		int iCharHei = met.getHeight();

		int len;
	 	int iCharLen = 0;
		if (title != null){
			len = met.stringWidth(title);
			iCharLen = (int)len;
		}

		Dimension d = size();

		//g.setColor (black);
		//g.drawRect(1,1,d.width-2,d.height-2);

		int offx = 3;
		int offy = iCharHei/2;

		int xpos = 0;
		int ypos = 0;

		int startx = xpos + offx;
		int starty = ypos + offy;
		int endx =  d.width - 2 * offx - 1;
		int endy =  d.height - 2 * offy + 1;

		// Rectangle de base autour du groupe avec effet 3D
		// Boite effect ombre

		g.setColor (dark);
		int endy_gray = starty + endy - 2;
		int endx_gray = startx + endx - 2;
		g.drawLine (startx,starty,startx,endy_gray);
		g.drawLine (startx,starty,endx_gray,starty);

		g.drawLine (startx,endy_gray,endx_gray,endy_gray);
		g.drawLine (endx_gray,starty,endx_gray,endy_gray);


		// Boite effect lumiere
		g.setColor (light);
		g.drawLine (startx+1,starty+1,startx+1,endy_gray-1);
		g.drawLine (startx+1,starty+1,endx_gray-1,starty+1);

		g.drawLine (startx,endy_gray+1,endx_gray+1,endy_gray+1);
		g.drawLine (endx_gray+1,starty,endx_gray+1,endy_gray+1);

		if (title != null){
			// Affiche le title du groupe en effacant l'arriere
			g.setColor (Color.lightGray);
			g.fillRect(startx+offx*2-2,starty-offy/2,iCharLen+4,iCharHei);

			g.setColor (black);
			g.drawString (title,startx+offx*2,starty-offy+2+10);
		}
	}
	public void paint(Graphics g) {
		super.paint(g);
		drawgroup(g);
	}
}
