LINUXCONF_REV=XXXLINUXCONFREVXXX
LINUXCONF_SUBREV=XXXLINUXCONFSUBREVXXX
LINUXCONF_SUBSUBREV=XXXLINUXCONFSUBSUBREVXXX

LDEVEL=/usr/lib/linuxconf-devel/
SOLUCORP_TOOLS=/usr/lib/solucorp-tools
LIB_LINUXCONF=$(RPM_BUILD_ROOT)/usr/lib/linuxconf
FLAGS=-funsigned-char -g -O2 -Wall


ifeq ($(LINUXCONF_SUBSUBREV),0)
ifeq ($(LINUXCONF_SUBREV),0)
PACKAGE_REV=$(LINUXCONF_REV)
else
PACKAGE_REV=$(LINUXCONF_REV)r$(LINUXCONF_SUBREV)
endif
else
PACKAGE_REV=$(LINUXCONF_REV)r$(LINUXCONF_SUBREV).$(LINUXCONF_SUBSUBREV)
endif

SOPATH=$(CURDIR).so.$(VERSION)


.SUFFIXES: .o .os .obt .help .html .sgml .txt .doc .tex .java .class .tlcc .cc

EGCS=$(shell test -f /usr/bin/egcs && /bin/echo -n 1)
ifeq ($(EGCS),1)
GPPLINK=egcs
GPP=egcs
else
GPP=g++
# Using g++ to link pulls libg++ even if the program does not need it
GPPLINK=gcc
endif

CPP_DEFINES=-Dexport= -DSTATIC= -DEXPORT= -DPUBLIC= -DPROTECTED= -DPRIVATE= -DVIRTUAL= \
	-Dnear= -Dfar=  -D_GNU_SOURCE -DUNIX

.cc.o:
	@echo "    " $<
	@$(GPP) $(FLAGS) $(CPP_DEFINES) -DPACKAGE_REV=\"$(PACKAGE_REV)\" \
		-I../tool -I../etc \
		-I/usr/include/linuxconf -c $< -o $@

.cc.os:
	@echo "    " $<
	@$(GPP) -fPIC $(FLAGS) $(CPP_DEFINES) -DPACKAGE_REV=\"$(PACKAGE_REV)\" \
		-I../tool -I../etc \
		-I/usr/include/linuxconf -c $< -o $@

.tlcc.o:
	@echo "    " $<
	@tlcc $< tmp.cpp
	@$(GPP) $(FLAGS) $(CPP_DEFINES) -DPACKAGE_REV=\"$(PACKAGE_REV)\" \
		-I/usr/include/tlmp -I/usr/include/linuxconf \
		-c tmp.cpp -o $@
	rm -f tmp.cpp

.tlcc.os:
	@echo "    " $<
	@tlcc $< tmp.cpp
	@$(GPP) -fPIC $(FLAGS) $(CPP_DEFINES) -DPACKAGE_REV=\"$(PACKAGE_REV)\" \
		-I/usr/include/tlmp -I/usr/include/linuxconf \
		-c tmp.cpp -o $@
	rm -f tmp.cpp

lib: $(CURDIR).a

$(CURDIR).a: $(OBJS)
	ar cr $(CURDIR).a $(OBJS)
	ranlib $(CURDIR).a


msg:
	$(LDEVEL)/msgscan $(CURDIR) \
		$(CURDIR).dic $(CURDIR).m EF *.{cc,tlcc}

msg.clean:
	@test -f $(CURDIR).m || (echo only in a project directory; exit 1)
	$(LDEVEL)/msgclean $(CURDIR).dic
	$(LDEVEL)/msgscan $(CURDIR) \
		$(CURDIR).dic $(CURDIR).m EF *.{cc,tlcc}
	make clean

ifdef DIRS
clean: $(LOCAL_CLEAN)
	rm -f x *.o *.os *.obt *.bak .bak *~ *.a *.old *.log *.nap *.nar core
	@for i in $(DIRS); do make -C $$i clean  || exit 1; done
else
clean: $(LOCAL_CLEAN)
	rm -f x *.o *.os *.obt *.bak *~ *.a *.old *.log *.nap *.nar
endif

install: $(LOCAL_INSTALL) $(LOCAL_POSTINSTALL)

include /usr/lib/linuxconf-devel/stdmod.mak

_dict.o: _dict.cc $(CURDIR).m

.sgml.txt:
	@echo Formatting $< '->' $@
	sgml2txt $(SGMLOPT) $<
	sgml2html $(SGMLOPT) $<

.sgml.html:
	@echo Formatting $< '->' $@
	sgml2html $(SGMLOPT) $<

.sgml.tex:
	@echo Formatting $< '->' $@
	sgml2latex $(SGMLOPT) $<


.txt.help:
	@mv $< $@

# Update the message dictionary for translators
syncmsg:
	@test "$(LANG)" != ""	 || echo LANG not defined
	@test "$(LANG)" != ""
	/usr/lib/linuxconf-devel/syncmsg.sh $(CURDIR) $(LANG)

