#!/bin/sh
# mirror_base.sh:	Mirror the stuff we need from Debian base archive
#			for the purposes of building boot-floppies

set -e

usage () {
cat <<EOU
Usage:  $0 <arch> <user> <site> <site_dir> <kver> <src_dir> <anon_rsyncP>

Mirror packages from the Debian archive needed to build the
boot-floppies.  Uses rsync, so needs an ssh connection to
va.debian.org.
EOU
}

if [ $# -ne 7 ]; then
    usage 1>&2
    exit 1
fi

arch=$1
user=$2
site=$3
mdir=$4
kver=$5
anon=$7
basearea="$6/scripts/basedisks"
rootarea="$6/scripts/rootdisk"
extract_subarch_list=`ls $rootarea/EXTRACT_LIST_${arch}_* 2>/dev/null` || true

rsync="rsync"	# set to "rsync -n" to test

files="$basearea/PACKAGES_all     $basearea/PACKAGES_$arch \
       $rootarea/EXTRACT_LIST_all $rootarea/EXTRACT_LIST_$arch \
       $extract_subarch_list"

for file in $files; do
    if [ ! -f $file ]; then
	echo "expected file $file is missing"
	exit -1
    fi
done

##
##  dynamically build the list of packages we need
##
to_build=''

for i in `cat $files`; do
   to_build="$to_build --include ${i}_* "
done

if [ $arch = "powerpc" ]; then
	to_build="$to_build --include kernel-source-${kver}_* --include kernel-patch-${kver}-powerpc_*"
	to_build="$to_build --include kernel-image-2.2.10-apus* --include pcmcia-modules-*"
fi

##
## run rsync
##

##
## Anonymous rsync takes a different syntax than
## authenticated rsync with rsh/ssh. Thus this if block.
##

if [ $anon = "no" ]; then
$rsync -Lprvt --delete --rsh ssh	\
	$to_build			\
	--include "kernel-image-${kver}_*"  \
	--include "kernel-image-${kver}-*" \
	--include "pcmcia-modules-${kver}_*" \
	--include "pcmcia-modules-${kver}-*" \
	--exclude '*.*'			\
	--exclude 'Packages'		\
	$user@$site:/$mdir/binary-$arch/ .
else
$rsync -Lprvt --delete	\
	$to_build			\
	--include "kernel-image-${kver}_*"  \
	--include "kernel-image-${kver}-*" \
	--include "pcmcia-modules-${kver}_*" \
	--include "pcmcia-modules-${kver}-*" \
	--exclude '*.*'			\
	--exclude 'Packages'		\
	$site/$mdir/binary-$arch/ .

fi
