// colors.cc   -*-c++-*-
//
//  Copyright 1999 Daniel Burrows
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING.  If not, write to
//  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//  Boston, MA 02111-1307, USA.

#include "colors.h"

#include <hash_map>

#include "../vscreen.h"
#include "../strhash.h"

int npairs=1;
// FIXME: is this right?  I --assume-- that it is; the curses documentation
// appears to say that any color but 0 can be changed.  But...

bool color_names_initialized=false;

hash_map<string, short> colormap;
hash_map<string, short> color_names;

void init_color_names()
{
  color_names["black"]=0;
  color_names["red"]=1;
  color_names["green"]=2;
  color_names["yellow"]=3;
  color_names["blue"]=4;
  color_names["magenta"]=5;
  color_names["cyan"]=6;
  color_names["white"]=7;
}

int get_color(const string name, short def_fg, short def_bg)
{
  hash_map<string,short>::iterator found;
  found=colormap.find(name);

  if(found==colormap.end())
    {
      int newnum=npairs++;

      init_pair(newnum, def_fg, def_bg);
      colormap[name]=newnum;

      return newnum;
    }
  else
    return found->second;
}

void set_color(const string name, short fg, short bg)
{
  hash_map<string,short>::iterator found=colormap.find(name);
  if(found==colormap.end())
    {
      int newnum=npairs++;

      init_pair(newnum, fg, bg);
      colormap[name]=newnum;
    }
  else
    {
      init_pair(found->second, fg, bg);

      // The following is necessary because ncurses is broken.
      // You see, the documentation for init_pair *claims* that the terminal
      // will be cleared and redrawn from scratch if an existing pair is
      // redefined.  The more fool you if you believe it!  No, you have to
      // do this yourself..sigh..
      vscreen_refresh();
    }
}

bool parse_color(string s, short &c)
{
  char *endptr;

  int rval=strtol(s.c_str(), &endptr, 0);
  if(*endptr)
    {
      if(!color_names_initialized)
	init_color_names();
      hash_map<string, short>::iterator found=color_names.find(s);
      if(found==color_names.end())
	return false;
      else
	{
	  c=found->second;
	  return true;
	}
    }
  else
    {
      c=rval;
      return true;
    }
}
