



package Debian::DebConf::Client::ConfModule;
use Debian::DebConf::ConfigDb;
use Debian::DebConf::Config;
use Debian::DebConf::AutoSelect;
use strict;
use Exporter;
use vars qw($AUTOLOAD @ISA @EXPORT_OK %EXPORT_TAGS);
@ISA = qw(Exporter);

@EXPORT_OK=qw(version capb stop reset title input beginblock endblock go
	      unset set get register unregister previous_module clear
	      start_frontend fset fget subst purge metaget visible exist);

%EXPORT_TAGS = (all => [@EXPORT_OK]);

my %commands;
map { $commands{uc $_}=1; } @EXPORT_OK;

$|=1;


sub import {
	exec "/usr/share/debconf/frontend", $0, @ARGV
		unless $ENV{DEBIAN_HAS_FRONTEND};

	Debian::DebConf::Client::ConfModule->export_to_level(1, @_);
}

sub stop {
	print "STOP\n";
	return;
}

sub AUTOLOAD {
	my $command = uc $AUTOLOAD;
	$command =~ s|.*:||; # strip fully-qualified portion

	die "Unsupported command \"$command\"." unless $commands{$command};
	
	my $c=join (' ', $command, @_);
	
	if ($c=~m/\n/) {
		warn "Warning: Newline present in parameters passwd to debconf.\n";
		warn "         This will probably cause strange things to happen!\n";
	}

	print "$c\n";
	my $ret=<STDIN>;
	chomp $ret;
	my @ret=split(/ /, $ret, 2);
	return @ret if wantarray;
	return $ret[1];
}


1
