/*
 * Copyright (c) 1999 The Java Apache Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software and design ideas developed by the Java
 *    Apache Project (http://java.apache.org/)."
 *
 * 4. The names "Cocoon", "Cocoon Servlet" and "Java Apache Project" must
 *    not be used to endorse or promote products derived from this software
 *    without prior written permission.
 *
 * 5. Products derived from this software may not be called "Cocoon"
 *    nor may "Cocoon" and "Java Apache Project" appear in their names without
 *    prior written permission of the Java Apache Project.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software and design ideas developed by the Java
 *    Apache Project (http://java.apache.org/)."
 *
 * THIS SOFTWARE IS PROVIDED BY THE JAVA APACHE PROJECT "AS IS" AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE JAVA APACHE PROJECT OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Java Apache Project. For more information
 * on the Java Apache Project please see <http://java.apache.org/>.
 */

package org.apache.cocoon;

/**
 * The Cocoon strings.
 *
 * @author <a href="mailto:stefano@apache.org">Stefano Mazzocchi</a>
 * @version $Revision: 1.13 $ $Date: 1999/10/26 16:20:35 $
 */

public interface Defaults {

    public static final String NAME = "Cocoon";
    public static final String VERSION = "1.5";

    public static final String INIT_ARG = "properties";
    public static final String PROPERTIES = "cocoon.properties";
    public static final String INTERNAL_PROPERTIES = "org/apache/cocoon/" + PROPERTIES;

    public static final String SHOW_STATUS = "selfservlet.enabled";
    public static final String STATUS_URL = "selvservlet.uri";
    public static final String STATUS_URL_DEFAULT = "/Cocoon.xml";
 	
    public static final String PARSER_PROP = "parser";
    public static final String PARSER_DEFAULT = "org.apache.cocoon.parser.OpenXMLParser";
    public static final String CACHE_PROP = "cache";
    public static final String CACHE_DEFAULT = "org.apache.cocoon.cache.CocoonCache";
    public static final String STORE_PROP = "store";
    public static final String STORE_DEFAULT = "org.apache.cocoon.store.CocoonStore";

    public static final String PRODUCER_PROP = "producer";
    public static final String PROCESSOR_PROP = "processor";
    public static final String FORMATTER_PROP = "formatter";
    public static final String BROWSERS_PROP = "browser";
    public static final String INTERPRETER_PROP = "interpreter";
    
    public static final String COCOON_PROCESS_PI = "cocoon-process";
    public static final String COCOON_FORMAT_PI = "cocoon-format";
    public static final String STYLESHEET_PI = "xml-stylesheet";
    
    public static final String DEFAULT_BROWSER = "default";
    
    public static final boolean DEBUG = false;
    public static final boolean VERBOSE = true;

}