#ifndef __CONFIG_H__ /* file wrapper */
#define __CONFIG_H__
/*
 * Jeffrey Friedl
 * Omron Corporation			ʳ
 * Nagaokakyoshi, Japan			617Ĺ
 *
 * jfriedl@nff.ncl.omron.co.jp
 *
 * This work is placed under the terms of the GNU General Purpose License
 * (the "GNU Copyleft").
 */

/*
Some overall control of how the library is built.
The default is that this entire file is either comments or ifdef'ed out.
However, you can set or modify things here as you like.
After each comment is an example setting (for many things with values,
perhaps the default as it exists at the time of this writing... for many
yes-no things, the opposite of the default) surrounded by
  #if 0
  #endif

The example is just that, an example... don't make changes without understand
what you're doing, of course.

-----------------------------------------------------------------------------

*/

/* apply_regex.c */

/*
 * APPLY_REGEX_MAX_CHAR_COUNT
 * Tells up to how many characters to check for simultaneously when
 * doing a search.  For example in a regex search of the pattern
 * "this is a|(the) pattern", any line must at least have the characters
 * " aehinpst" somewhere in it. Apply_regex will run down the linked lists
 * of the APPLY_REGEX_MAX_CHAR_COUNT least common characters required in
 * a pattern, and for any line in all of the lists, the regex will be
 * applied.
 *
 * For large databases with random data, a value more than one or two can
 * lead to significant speed increases. Diminishing returns probably hit
 * quickly, though.
 */
#if 0
#  define APPLY_REGEX_MAX_CHAR_COUNT 10
#endif


/* fuzzkana.c */

/*
 * SMALL_TSU_OK
 * Tells which consonant sounds are allowed to be proceeded by a small tsu.
 */
#if 0
# define SMALL_TSU_OK (KID_K|KID_S|KID_T|KID_D|KID_P|KID_W|KID_M)
#endif


/* index.c */

/*
 * USE_SHORT_INDEX_COUNTS
 * If true, an 'elementcount' will be 'unsigned short', 'unsigned' otherwise.
 * The size of a count variable can limit the number of lines that an index
 * can refer to for any specific character (65535 lines for two-byte shorts,
 * for example).  Characters on "too many" lines will be automatically omitted
 * from the index.
 *
 * This is merely a size-of-index vs. index-ability issue.
 */
#if 0
# define USE_SHORT_INDEX_COUNTS	1
#endif

/* jreadline.c */

/*
 * NO_HANDLE_SIGNALS
 * The jreadline package will normally catch signals, clean up the tty
 * state, then deliver them to the program as if jreadline wasn't there.
 * Define this to remove jreadline's doing anything with signals.
 */
#if 0
# define NO_HANDLE_SIGNALS
#endif

/*
 * NO_AUTO_ROMAJI_CONVERSION
 * The jreadline package normally provides automatic romaji->kana conversion
 * (the "access" program doesn't use it, however). Defining this removes the
 * automatic conversion.
 */
#if 0
# define NO_AUTO_ROMAJI_CONVERSION
#endif

/*
 * NON_ANSIFIED_IOCTL
 * If sys/ioctl.h has not yet been ANSIfied, define this.
 */
#if 0
# define NON_ANSIFIED_IOCTL
#endif

/*
 * MAX_INPUT_LINE_LENGTH
 * Maximum length of an input line.
 */
#if 0
# define MAX_INPUT_LINE_LENGTH 200
#endif


/* jregex.c */

/*
 * NO_REGEXEC_MATCH_POINTS
 * Removes support for regexec_match_start and regexec_match_end,
 * Which removes support for \& in replace as well.
 * The support is so painless that it's probably silly to define this.
 */
#if 0
# define NO_REGEXEC_MATCH_POINTS
#endif

/*
 * DONT_WORRY_ABOUT_KATAKANA_DASH_BEING_PART_OF_A_WORD
 * Normally the word-boundary checks will take special care to count
 * a katakana dash as part of a kanji word. This support is removed
 * by defining this. Unless you know you'll be doing a *lot* of word-
 * boundary stuff and that you'll *not* be dealing with a dash, probably
 * silly to remove this support.
 */
#if 0
# define DONT_WORRY_ABOUT_KATAKANA_DASH_BEING_PART_OF_A_WORD
#endif

/*
 * NO_PAREN_INFO
 * Defining this removes support for regexec_paren_info, etc., which
 * is the mechanism by which one can find out what \1, \2, \3, etc. are
 * in a pattern. This also removes the ability to use \1, \2, \3, etc.
 * *in* a pattern (such as in the pattern to find double-words:
 *  "\<(\w+) \1\>").
 *
 * Removing this support by defining this symbol reduces the size of
 * regcomp and regexec, although the speed of regexec will be little
 * affected when paren info isn't requested.
 */
#if 0
# define NO_PAREN_INFO
#endif

/*
 * NO_DEFAULT_PAREN_INFO
 * If defined, there will be no default paren_info stuff allocated.
 * Only matters if NO_PAREN_INFO is not defined, of course.
 */
#if 0
  #ifndef NO_PAREN_INFO
     #define NO_DEFAULT_PAREN_INFO
  #endif
#endif

/*
 * DEFAULT_PAREN_INFO_SIZE
 * Sets the size of the default paren_info. Only matters if both NO_PAREN_INFO
 * and NO_DEFAULT_PAREN_INFO are not defined.
 */
#if 0
  #ifndef NO_PAREN_INFO
     #ifndef NO_DEFAULT_PAREN_INFO
        #define DEFAULT_PAREN_INFO_SIZE 10
     #endif
  #endif
#endif


/*
 * NO_SHOWREGEX
 * Don't compile in the showregex() function.
 * I should just partition this out into another file.
 */
#if 0
# define NO_SHOWREGEX
#endif

/*
 * FAST_REGEXEC
 * If set, removes debug-ability from regexec so that it doesn't have to
 * waste time on checking to see if debugging is turned on. For maximum
 * regexec speed.
 */
#if 0
# define FAST_REGEXEC
#endif

/*
 * UNALIGNED_SHORT_ACCESS_OK
 * If a short pointer can be to any byte (instead of, say, requiring alignment
 * to a 2-byte boundary), set this to true for some small speed optimization.
 */
#if 0
# define UNALIGNED_SHORT_ACCESS_OK
#endif


/* romaji2kana.c */
/*
 * R2K_DEFAULT_FLAGS
 * Sets the default flags for the conversion.
 */
#if 0
# define R2K_DEFAULT_FLAGS  R2K_UNCONVERTED_PUNC_OK|R2K_NONASCII_OK
#endif


/* std_romaji.c */

/* generic */

/*
 * MOVE_MEMORY(from, to, length)
 * Provides a save (i.e. OK to overlap) memory move.
 */
#define MOVE_MEMORY(FROM, TO, LENGTH) \
    (void)bcopy((char*)(FROM), (char*)(TO), (int)(LENGTH))

/*
 * NDEBUG
 * If defined, removes assert() and many other debugging provisions.
 */
#if 0
# define NDEBUG
#endif 

/*
 * USE_LOCAL_OUTPUT
 * If defined, uses local output library (rather than stdio)
 * and allows for switchable Japanese-output encoding.
 */
#define USE_LOCAL_OUTPUT

/*
 * USE_LOCAL_INPUT
 * If true, use local input routines. Used to be useful, but no longer.
 */
#define USE_LOCAL_INPUT 0

/*
 * PROVIDE_PAGER
 *
 * If set to true, provides the means for a local pager (but only if
 * USE_LOCAL_OUTPUT also true.
 */
#ifdef SERVER_CONFIG
#  define PROVIDE_PAGER 0
#else
#  define PROVIDE_PAGER 1
#endif


/*
 * Macro helpers, to allow full blocks to appear like single statements.
 *
 * Used as in:
 *     #define do_it(arg1, arg2)
 *     macro_start {
 *         int ARG1 = (arg1);
 *         int ARG2 = (arg2);
 *         blah blah blah.
 *     } macro_end
 * 
 * This would allow the use of do_it() even in situations such as
 *    
 *    if (something)
 *         do_it(x,y);
 *    else
 *         blahblahblah();
 *
 */
#ifndef macro_start
# define macro_start  do
# define macro_end    while (0)
#endif

/* some general system-V stuff */
#if defined(__svr4__) || defined(__DGUX__)
# define index strchr
# define rindex strrchr
# define bcopy(FROM, TO, LENGTH) memcpy(TO, FROM, LENGTH)
# if !defined(__DGUX__) /* DGUX memset is broken */
#   define bzero(ADDR, LENGTH)     memset(ADDR, LENGTH, 0)
# endif
#endif

/*************************************************************************/
#endif /* file wrapper */
